% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggm.R
\name{gen_partial_correlations}
\alias{gen_partial_correlations}
\title{Generate partial correlations for a list of networks.}
\usage{
gen_partial_correlations(..., k = 2.5, rweights = function(n)
  (-1)^rbinom(n, 1, 0.5) * runif(n, 0.5, 1))
}
\arguments{
\item{...}{The 'network' objects to modify.}

\item{k}{An integer that ensures the matrix inverse is numerically stable. 
k = 2.5 is default; higher values will allow for larger values of
partial correlations (and will result in a wider distribution of 
Pearson correlations).}

\item{rweights}{A generator for initial weights in the network. By default, 
values are generated uniformly from (-1, -0.5) U (0.5, 1). The weights will
be adjusted so that the sign of a generated weight and the sign of the
corresponding partial correlation agree.}
}
\value{
An updated network object containing random weights. If multiple
networks were provided, then a list of network objects is returned.
}
\description{
Random partial correlations are generated to weigh the network connections. 
If multiple networks are provided, the networks must contain the same nodes
and the same modules (the connections within modules may differ). Any 
connection that is common across different networks will also have the same 
partial correlation weight across networks.
}
\examples{
nw <- random_network(10) # Create a random network with 10 nodes.
nw <- gen_partial_correlations(nw) # Add weights to connections in the network.
}
