% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables.R
\name{exportSingleResult}
\alias{exportSingleResult}
\title{Export a SetRank network and accompanying tables.}
\usage{
exportSingleResult(network, selectedGenes, collection, networkName,
  IDConverter = NULL, outputPath = "./")
}
\arguments{
\item{network}{A SetRank network.}

\item{selectedGenes}{A vector with the set of significant genes as Entrez
Gene IDs. This should be the same set passed to the 
\code{\link[SetRank]{setRankAnalysis}} function.}

\item{collection}{The set collection used for the SetRank analysis.}

\item{networkName}{A name used to name the different output files.}

\item{IDConverter}{Optional. By default, Entrez Gene IDs will be displayed
in the output tables. This argument can be used to convert these into more 
human-friendly gene symbols. When supplied, should be a function that takes 
a vector of Entrez Gene IDs as single argument and returns the values of the
corresponding gene symbols or whatever identifier you wish to have displayed
in the output tables.}

\item{outputPath}{The name of the directory where the results should be 
written. If the last element of the path doesn't exist, a directory will be
created.}
}
\value{
None. Files are written out as a side effect. 
genes = sprintf("gene_%03d", 1:100)
geneSets = lapply(1:9, function(i) sample(genes[((i-1)*10):((i+1)*10)], 10))
annotationTable = data.frame(termID=sprintf("set_%02d", rep(1:9, each=10)), 
        geneID=unlist(geneSets),
        termName = sprintf("dummy gene set %d", rep(1:9, each=10)),
        dbName = "dummyyDB",
        description = "A dummy gene set DB for testing purposes")
collection = buildSetCollection(annotationTable, referenceSet=genes)
network = setRankAnalysis(genes, collection, TRUE)
exportSingleResult(network, genes, collection, "example", function(x) x, "example_dir")
}
\description{
Given a single SetRank analysis result, writes out the following files:
\enumerate{
\item SetRank network in GML format called \code{<n>.gml} where \code{<n>}
is the specified network name.
\item A Cytoscape VizMap visualisation file, called \code{setrank.xml}.
\item A TAB-delimited file listing the signficant pathways in the network,
called \code{<n>_pathways.txt} with \code{<n>} again the network name.
\item A TAB-delimited file listing which significant genes belong to which
pathway, called  \code{<n>_membership.txt} with \code{<n>} again the network
name.
}
}
\author{
Cedric Simillion
}

