% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction.R
\name{AddMetaData}
\alias{AddMetaData}
\title{Add Metadata}
\usage{
AddMetaData(object, metadata, col.name = NULL)
}
\arguments{
\item{object}{Seurat object}

\item{metadata}{Data frame where the row names are cell names (note : these
must correspond exactly to the items in object@cell.names), and the columns
are additional metadata items.}

\item{col.name}{Name for metadata if passing in single vector of information}
}
\value{
Seurat object where the additional metadata has been added as
columns in object@meta.data
}
\description{
Adds additional data for single cells to the Seurat object. Can be any piece
of information associated with a cell (examples include read depth,
alignment rate, experimental batch, or subpopulation identity). The
advantage of adding it to the Seurat object is so that it can be
analyzed/visualized using FetchData, VlnPlot, GenePlot, SubsetData, etc.
}
\examples{
cluster_letters <- LETTERS[pbmc_small@ident]
pbmc_small <- AddMetaData(
  object = pbmc_small,
  metadata = cluster_letters,
  col.name = 'letter.idents'
)
head(x = pbmc_small@meta.data)

}
