% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{ReadMtx}
\alias{ReadMtx}
\title{Load in data from remote or local mtx files}
\usage{
ReadMtx(
  mtx,
  cells,
  features,
  cell.column = 1,
  feature.column = 2,
  skip.cell = 0,
  skip.feature = 0,
  unique.features = TRUE,
  strip.suffix = FALSE
)
}
\arguments{
\item{mtx}{Name or remote URL of the mtx file}

\item{cells}{Name or remote URL of the cells/barcodes file}

\item{features}{Name or remote URL of the features/genes file}

\item{cell.column}{Specify which column of cells file to use for cell names; default is 1}

\item{feature.column}{Specify which column of features files to use for feature/gene names; default is 2}

\item{skip.cell}{Number of lines to skip in the cells file before beginning to read cell names}

\item{skip.feature}{Number of lines to skip in the features file before beginning to gene names}

\item{unique.features}{Make feature names unique (default TRUE)}

\item{strip.suffix}{Remove trailing "-1" if present in all cell barcodes.}
}
\value{
A sparse matrix containing the expression data.
}
\description{
Enables easy loading of sparse data matrices
}
\examples{
\dontrun{
# For local files:

expression_matrix <- ReadMtx(
  mtx = "count_matrix.mtx.gz", features = "features.tsv.gz",
  cells = "barcodes.tsv.gz"
)
seurat_object <- CreateSeuratObject(counts = expression_matrix)

# For remote files:

expression_matrix <- ReadMtx(mtx = "http://localhost/matrix.mtx",
cells = "http://localhost/barcodes.tsv",
features = "http://localhost/genes.tsv")
seurat_object <- CreateSeuratObject(counts = data)
}

}
\concept{preprocessing}
