% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{HVFInfo.SCTAssay}
\alias{HVFInfo.SCTAssay}
\title{Get Variable Feature Information}
\usage{
\method{HVFInfo}{SCTAssay}(object, method, status = FALSE, ...)
}
\arguments{
\item{object}{An object}

\item{method}{method to determine variable features}

\item{status}{Add variable status to the resulting data frame}

\item{...}{Arguments passed to other methods}
}
\description{
Get variable feature information from \code{\link{SCTAssay}} objects
}
\examples{
\dontrun{
# Get the HVF info directly from an SCTAssay object
pbmc_small <- SCTransform(pbmc_small)
HVFInfo(pbmc_small[["SCT"]], method = 'sct')[1:5, ]
}

}
\seealso{
\code{\link[SeuratObject]{HVFInfo}}
}
\concept{objects}
