% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.r
\name{sr_test}
\alias{sr_test}
\title{test for Sharpe ratio}
\usage{
sr_test(x,y=NULL,alternative=c("two.sided","less","greater"),
        zeta=0,ope=1,paired=FALSE,conf.level=0.95)
}
\arguments{
\item{x}{a (non-empty) numeric vector of data values, or an
object of class \code{sr}, containing a scalar sample Sharpe estimate.}

\item{y}{an optional (non-empty) numeric vector of data values, or
an object of class \code{sr}, containing a scalar sample Sharpe estimate.
Only an unpaired test can be performed when at least one of \code{x} and \code{y} are
of class \code{sr}}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or
\code{"less"}.  You can specify just the initial letter.}

\item{zeta}{a number indicating the null hypothesis offset value, the
\eqn{S} value.}

\item{ope}{the number of observations per 'epoch'. For convenience of
interpretation, The Sharpe ratio is typically quoted in 'annualized' 
units for some epoch, that is, 'per square root epoch', though returns 
are observed at a frequency of \code{ope} per epoch. 
The default value is 1, meaning the code will not attempt to guess
what the observation frequency is, and no annualization adjustments
will be made.}

\item{paired}{a logical indicating whether you want a paired test.}

\item{conf.level}{confidence level of the interval.}

\item{...}{further arguments to be passed to or from methods.}
}
\value{
A list with class \code{"htest"} containing the following components:
\item{statistic}{the value of the t- or Z-statistic.}
\item{parameter}{the degrees of freedom for the statistic.}
\item{p.value}{the p-value for the test.}
\item{conf.int}{a confidence interval appropriate to the specified alternative hypothesis. NYI for some cases.}
\item{estimate}{the estimated Sharpe or difference in Sharpes depending on whether it was a one-sample test or a two-sample test. Annualized}
\item{null.value}{the specified hypothesized value of the Sharpe or difference of Sharpes depending on whether it was a one-sample test or a two-sample test.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
}
\description{
Performs one and two sample tests of Sharpe ratio on vectors of data.
}
\details{
Given \eqn{n}{n} observations \eqn{x_i}{xi} from a normal random variable,
with mean \eqn{\mu}{mu} and standard deviation \eqn{\sigma}{sigma}, tests
\deqn{H_0: \frac{\mu}{\sigma} = S}{H0: mu/sigma = S}
against two or one sided alternatives.

Can also perform two sample tests of Sharpe ratio. For paired observations
\eqn{x_i}{xi} and \eqn{y_i}{yi}, tests
\deqn{H_0: \frac{\mu_x}{\sigma_x} = \frac{\mu_u}{\sigma_y}}{H0: mu_x sigma_y = mu_y sigma_x}
against two or one sided alternative, via 
\code{\link{sr_equality_test}}.

For unpaired (and independent) observations, tests
\deqn{H_0: \frac{\mu_x}{\sigma_x} - \frac{\mu_u}{\sigma_y} = S}{H0: mu_x / sigma_x - mu_y / sigma_y = S}
against two or one-sided alternatives via the upsilon distribution.
}
\examples{
# should reject null
x <- sr_test(rnorm(1000,mean=0.5,sd=0.1),zeta=2,ope=1,alternative="greater")
x <- sr_test(rnorm(1000,mean=0.5,sd=0.1),zeta=2,ope=1,alternative="two.sided")
# should not reject null
x <- sr_test(rnorm(1000,mean=0.5,sd=0.1),zeta=2,ope=1,alternative="less")

# test for uniformity
pvs <- replicate(128,{ x <- sr_test(rnorm(1000),ope=253,alternative="two.sided")
                        x$p.value })
plot(ecdf(pvs))
abline(0,1,col='red') 
# testing an object of class sr
asr <- as.sr(rnorm(1000,1 / sqrt(253)),ope=253)
checkit <- sr_test(asr,zeta=0)

}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\references{
Sharpe, William F. "Mutual fund performance." Journal of business (1966): 119-138.
\url{http://ideas.repec.org/a/ucp/jnlbus/v39y1965p119.html}

Pav, Steven. "Inference on the Sharpe ratio via the upsilon distribution.'
Arxiv (2015). 
\url{http://arxiv.org/abs/1505.00829}
}
\seealso{
\code{\link{reannualize}}

\code{\link{sr_equality_test}}, \code{\link{sr_unpaired_test}}, \code{\link{t.test}}.

Other sr: \code{\link{as.sr}}, \code{\link{confint.sr}},
  \code{\link{dsr}}, \code{\link{is.sr}},
  \code{\link{plambdap}}, \code{\link{power.sr_test}},
  \code{\link{predint}}, \code{\link{print.sr}},
  \code{\link{reannualize}}, \code{\link{se}},
  \code{\link{sr_equality_test}},
  \code{\link{sr_unpaired_test}}, \code{\link{sr_vcov}},
  \code{\link{sr}}, \code{\link{summary}}
}
\keyword{htest}

