% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tests.r
\name{sropt_test}
\alias{sropt_test}
\title{test for optimal Sharpe ratio}
\usage{
sropt_test(X,alternative=c("greater","two.sided","less"),
            zeta.s=0,ope=1,conf.level=0.95)
}
\arguments{
\item{X}{a (non-empty) numeric matrix of data values, each row independent,
each column representing an asset, or an object of 
class \code{sropt}.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of \code{"two.sided"}, \code{"greater"} (default) or
\code{"less"}.  You can specify just the initial letter.}

\item{zeta.s}{a number indicating the null hypothesis value.}

\item{ope}{the number of observations per 'epoch'. For convenience of
interpretation, The Sharpe ratio is typically quoted in 'annualized' 
units for some epoch, that is, 'per square root epoch', though returns 
are observed at a frequency of \code{ope} per epoch. 
The default value is 1, meaning the code will not attempt to guess
what the observation frequency is, and no annualization adjustments
will be made.}

\item{conf.level}{confidence level of the interval. (not used yet)}
}
\value{
A list with class \code{"htest"} containing the following components:
\item{statistic}{the value of the \eqn{T^2}-statistic.}
\item{parameter}{a list of the degrees of freedom for the statistic.}
\item{p.value}{the p-value for the test.}
\item{conf.int}{a confidence interval appropriate to the specified alternative hypothesis. NYI.}
\item{estimate}{the estimated optimal Sharpe, annualized}
\item{null.value}{the specified hypothesized value of the optimal Sharpe.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
}
\description{
Performs one sample tests of Sharpe ratio of the Markowitz portfolio.
}
\details{
Suppose \eqn{x_i}{xi} are \eqn{n}{n} independent draws of a \eqn{q}{q}-variate
normal random variable with mean \eqn{\mu}{mu} and covariance matrix
\eqn{\Sigma}{Sigma}. This code tests the hypothesis
\deqn{H_0: \mu^{\top}\Sigma^{-1}\mu = \delta_0^2}{H0: mu' Sigma^-1 mu = delta_0^2}

The default alternative hypothesis is the one-sided 
\deqn{H_1: \mu^{\top}\Sigma^{-1}\mu > \delta_0^2}{H1: mu' Sigma^-1 mu > delta_0^2}
but this can be set otherwise.

Note there is no 'drag' term here since this represents a linear offset of
the population parameter.

See \sQuote{The Sharpe Ratio: Statistics and Applications},
section 6.3.2.
}
\examples{

# test for uniformity
pvs <- replicate(128,{ x <- sropt_test(matrix(rnorm(1000*4),ncol=4),alternative="two.sided")
                        x$p.value })
plot(ecdf(pvs))
abline(0,1,col='red') 

# input a sropt objects:
nfac <- 5
nyr <- 10
ope <- 253
# simulations with no covariance structure.
# under the null:
set.seed(as.integer(charToRaw("be determinstic")))
Returns <- matrix(rnorm(ope*nyr*nfac,mean=0,sd=0.0125),ncol=nfac)
asro <- as.sropt(Returns,drag=0,ope=ope)
stest <- sropt_test(asro,alternative="two.sided")

}
\references{
Pav, S. E. "The Sharpe Ratio: Statistics and Applications." CRC Press, 2021.
}
\seealso{
\code{\link{reannualize}}

\code{\link{sr_test}}, \code{\link{t.test}}.

Other sropt: 
\code{\link{as.sropt}()},
\code{\link{confint.sr}()},
\code{\link{dsropt}()},
\code{\link{is.sropt}()},
\code{\link{pco_sropt}()},
\code{\link{power.sropt_test}()},
\code{\link{reannualize}()},
\code{\link{sropt}}
}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\concept{sropt}
\keyword{htest}
