% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggWrightMap.R
\name{ggWrightMap}
\alias{ggWrightMap}
\title{Wright Map using ggplot}
\usage{
ggWrightMap(theta, b, binwidth = 0.5, color = "blue", size = 15)
}
\arguments{
\item{theta}{numeric: vector of ability estimates}

\item{b}{numeric: vector of difficulty estimates}

\item{binwidth}{numeric: the width of the bins of histogram}

\item{color}{character: color of histogram}

\item{size}{text size in pts}
}
\description{
This function allows to generate Wright Map (also called item-person map)
using ggplot() function from package ggplot2. Wright Map is used to display histogram
of factor scores and the item difficulty parameters estimated by the Rasch IRT model.
}
\examples{
\dontrun{
library(ShinyItemAnalysis)
library(mirt)

data(dataMedical)
data <- dataMedical[, 1:100]

# Model
fit <- mirt(data, model = 1, itemtype = "Rasch")
# factor scores
theta <- as.vector(fscores(fit))
# difficulty estimates
b <- coef(fit, simplify = T)$items[, "d"]

ggWrightMap(theta, b)
}
}
\references{
Wright, B. D., & Stone, M. H. (1979). Best test design.
}
\seealso{
\code{\link[WrightMap]{wrightMap}}
}
\author{
Adela Drabinova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
drabinova@cs.cas.cz \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
martinkova@cs.cas.cz \cr
}
