% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make.functions.R
\name{make.exp.decay}
\alias{make.exp.decay}
\title{Make an exponential decay function}
\usage{
make.exp.decay(t = 1, s = 1)
}
\arguments{
\item{t}{A numeric representing how quickly the hybridization success decays. Samaller values denote a quicker decay}

\item{s}{A numeric for the power that the genetic distance is raised.}
}
\value{
An exponential decay function
}
\description{
Create an exponential decay function for genetic distance of two taxa and the probability of success of a hybridization event
}
\details{
The function computes: \deqn{e^{- \frac{d^{s}}{t}}}{ exp(-(d^s)/t) }
where d is the genetic distance between taxa
}
\examples{
set.seed(17)
dist_func<- make.exp.decay(1,1)
net<-sim.bdh.age(1,1,5,2,2,c(1/3,1/3,1/3),hyb.inher.fxn = make.uniform.draw(),
hyb.rate.fxn=dist_func,complete=TRUE)[[1]]
}
