% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_functions.R
\name{CID.writeJSON}
\alias{CID.writeJSON}
\title{Writes JSON file for SPRING integration}
\usage{
CID.writeJSON(
  cr,
  json_new = "categorical_coloring_data.json",
  spring.dir,
  new_populations = NULL,
  new_colors = NULL
)
}
\arguments{
\item{cr}{output from \code{\link{GenerateLabels}}}

\item{json_new}{Filename where annotations will be saved for new SPRING color tracks. Default is "categorical_coloring_data_new.json".}

\item{spring.dir}{Directory where file 'categorical_coloring_data.json' is located. If set, will add Signac annotations to the file.}

\item{new_populations}{Character vector specifying any new cell types that Signac has learned. Default is NULL.}

\item{new_colors}{Character vector specifying the HEX color codes for new cell types. Default is NULL.}
}
\value{
A categorical_coloring_data.json file with Signac annotations and Louvain clusters added.
}
\description{
\code{CID.writeJSON} is a SPRING-integrated function for writing a JSON file.
}
