% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/SimInf_model.R
\docType{methods}
\name{U}
\alias{U}
\alias{U,SimInf_model-method}
\title{Extract the number of individuals in each compartment}
\usage{
U(model)

\S4method{U}{SimInf_model}(model)
}
\arguments{
\item{model}{The \code{model} to extract the result matrix from.}
}
\value{
The number of individuals in each compartment
}
\description{
The result matrix with the number of individuals in each
compartment in every node after running a trajectory with
\code{\link{run}}. \code{U[, j]} contains the number of
individuals in each compartment at \code{tspan[j]}. \code{U[1:Nc,
j]} contains the number of individuals in node 1 at
\code{tspan[j]}. \code{U[(Nc + 1):(2 * Nc), j]} contains the
number of individuals in node 2 at \code{tspan[j]} etc, where
\code{Nc} is the number of compartments in the model. The
dimension of the matrix is \eqn{N_n N_c \times}
\code{length(tspan)} where \eqn{N_n} is the number of nodes.
}
\examples{
## Create an 'SIR' model with 6 nodes and initialize
## it to run over 10 days.
u0 <- data.frame(S = 100:105, I = 1:6, R = rep(0, 6))
model <- SIR(u0 = u0, tspan = 1:10, beta = 0.16, gamma = 0.077)

## Run the model
result <- run(model, seed = 123)

## Extract the number of individuals in each compartment at the
## time-points in tspan.
U(result)
}
\keyword{methods}
