% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimInf_events.R
\name{SimInf_events}
\alias{SimInf_events}
\title{Create a \code{\linkS4class{SimInf_events}} object}
\usage{
SimInf_events(E = NULL, N = NULL, events = NULL, t0 = NULL)
}
\arguments{
\item{E}{Each row corresponds to one compartment in the model. The
non-zero entries in a column indicates the compartments to
include in an event.  For the \emph{exit}, \emph{internal
transfer} and \emph{external transfer} events, a non-zero
entry indicate the compartments to sample individuals from.
For the \emph{enter} event, all individuals enter first
non-zero compartment. \code{E} is sparse matrix of class
\code{\linkS4class{dgCMatrix}}.}

\item{N}{Determines how individuals in \emph{internal transfer}
and \emph{external transfer} events are shifted to enter
another compartment.  Each row corresponds to one compartment
in the model.  The values in a column are added to the current
compartment of sampled individuals to specify the destination
compartment, for example, a value of \code{1} in an entry
means that sampled individuals in this compartment are moved
to the next compartment.  Which column to use for each event
is specified by the \code{shift} vector (see below).  \code{N}
is an integer matrix.}

\item{events}{A \code{data.frame} with events.}

\item{t0}{If \code{events$time} is a \code{Date} vector, then
\code{t0} determines the offset to match the time of the
events to the model \code{tspan} vector, see details. If
\code{events$time} is a numeric vector, then \code{t0} must be
\code{NULL}.}
}
\value{
S4 class \code{SimInf_events}
}
\description{
The argument events must be a \code{data.frame} with the following
columns:
\describe{
  \item{event}{
    Four event types are supported by the current solvers:
    \emph{exit}, \emph{enter}, \emph{internal transfer}, and
    \emph{external transfer}.  When assigning the events, they can
    either be coded as a numerical value or a character string:
    \emph{exit;} \code{0} or \code{'exit'}, \emph{enter;} \code{1}
    or \code{'enter'}, \emph{internal transfer;} \code{2} or
    \code{'intTrans'}, and \emph{external transfer;} \code{3} or
    \code{'extTrans'}.  Internally in \pkg{SimInf}, the event type
    is coded as a numerical value.
  }
  \item{time}{
    When the event occurs i.e., the event is processed when time
    is reached in the simulation. Can be either an \code{integer}
    or a \code{Date} vector.  A \code{Date} vector is coerced to a
    numeric vector as days, where \code{t0} determines the offset
    to match the time of the events to the model \code{tspan}
    vector.
  }
  \item{node}{
    The node that the event operates on. Also the source node for
    an \emph{external transfer} event.
    1 <= \code{node[i]} <= Number of nodes.
  }
  \item{dest}{
    The destination node for an \emph{external transfer} event
    i.e., individuals are moved from \code{node} to \code{dest},
    where 1 <= \code{dest[i]} <= Number of nodes.  Set \code{event
    = 0} for the other event types.  \code{dest} is an integer
    vector.
  }
  \item{n}{
    The number of individuals affected by the event. n[i] >= 0.
  }
  \item{proportion}{
    If \code{n[i]} equals zero, the number of individuals affected by
    \code{event[i]} is calculated by summing the number of individuls
    with \code{proportion[i]}. 0 <= proportion[i] <= 1.
  }
  \item{select}{
    To process \code{event[i]}, the compartments affected by the
    event are specified with \code{select[i]} together with the
    matrix \code{E}, where \code{select[i]} determines which
    column in \code{E} to use.  The specific individuals affected
    by the event are proportionally sampled from the compartments
    corresponding to the non-zero entries in the specified column
    in \code{E[, select[i]]}, where \code{select} is an integer
    vector.
  }
  \item{shift}{
    Determines how individuals in \emph{internal transfer} and
    \emph{external transfer} events are shifted to enter another
    compartment.  The sampled individuals are shifted according to
    column \code{shift[i]} in matrix \code{N} i.e., \code{N[,
    shift[i]]}, where \code{shift} is an integer vector.  See
    above for a description of \code{N}. Unsued for the other
    event types.
  }
}
}
