% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analyse_piecewise_exponential.R
\name{analyse_piecewise_exponential}
\alias{analyse_piecewise_exponential}
\title{Create Analyse function for piecewise exponential model}
\usage{
analyse_piecewise_exponential(cuts, testing_only = FALSE)
}
\arguments{
\item{cuts}{interval boundaries for the piecewise exponential model}

\item{testing_only}{if set to \code{TRUE} omits all statistics in the
intervals and just returns the p value of the global test.}
}
\value{
an analyse function that can be used in runSimulation
}
\description{
Create Analyse function for piecewise exponential model
}
\details{
If there's any time interval no patients ever enter, NA is returned
for all time intervals. This behavior will likely change in future package
versions.
}
\examples{
condition <- merge(
   assumptions_delayed_effect(),
   design_fixed_followup(),
   by=NULL
 ) |>
 head(1)
dat <- generate_delayed_effect(condition)
analyse_piecewise_exponential(cuts=c(90, 360))(condition, dat)
}
