% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PedSim_Functions.R
\name{sim_founderRVstatus}
\alias{sim_founderRVstatus}
\title{Determine founder genotype at the disease locus and determime their relative-risk of disease}
\usage{
sim_founderRVstatus(GRR, carrier_prob, RVfounder)
}
\arguments{
\item{GRR}{Numeric. The genetic relative-risk of disease, i.e. the relative-risk of disease for individuals who carry at least one copy of the causal variant.}

\item{carrier_prob}{Numeric.  The carrier probability for all causal variants with relative-risk of disease \code{GRR}.  By default, \code{carrier_prob}\code{ = 0.002}}

\item{RVfounder}{Logical.  Indicates if all pedigrees segregate the rare, causal variant.  By default, \code{RVfounder = FALSE} See details.}

\item{intro_RV}{Logical. If \code{intro_RV = TRUE} a founder has introduced a rare, causal variant to the pedigree, otherwise no RV has been introduced to the pedigree.}
}
\value{
A list containing: 1. the founder's genotype at the disease locus, their relative-risk of disease, and an updated value for intro_RV.
}
\description{
Determine founder genotype at the disease locus and determime their relative-risk of disease
}
\keyword{internal}
