% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{P_y_given_x}
\alias{P_y_given_x}
\title{Get probabilities y_i given ontological term sets x_i (\code{term_sets}) based on SimReg parameter values sampled with \code{\link{sim_reg}}}
\usage{
P_y_given_x(term_sim_mat, term_sets, samples, g = rep(FALSE,
  length(term_sets)), ontology = NULL, term_descendancy_matrix = NULL)
}
\arguments{
\item{term_sim_mat}{Numeric matrix of similarities between individual terms, typically created with \code{get_term_sim_mat}}

\item{term_sets}{List of character vectors of ontological term IDs.}

\item{samples}{Object of class \code{sim_reg_samples}, i.e. the output of the \code{\link{sim_reg}} function.}

\item{g}{Genotype log odds offsets per individual.}

\item{ontology}{\code{ontology_index} object.}

\item{term_descendancy_matrix}{Logical term descendancy matrix, dimensions symmetrically labelled by terms, and where by a cell value of TRUE indicates that the row is the ancestor of the column term (in the sense of the DAG structure of the HPO.}
}
\value{
Numeric vector of probabilities
}
\description{
Get probabilities y_i given ontological term sets x_i (\code{term_sets}) based on SimReg parameter values sampled with \code{\link{sim_reg}}
}

