
# This file is automatically generated, you probably don't want to edit this

jmvreliOptions <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "jmvreliOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            vars = NULL,
            ciWidth = 95,
            desc = FALSE,
            plots = FALSE, ...) {

            super$initialize(
                package="SimplyAgree",
                name="jmvreli",
                requiresData=TRUE,
                ...)

            private$..vars <- jmvcore::OptionVariables$new(
                "vars",
                vars,
                suggested=list(
                    "continuous"),
                permitted=list(
                    "numeric"),
                rejectInf=FALSE)
            private$..ciWidth <- jmvcore::OptionNumber$new(
                "ciWidth",
                ciWidth,
                min=50,
                max=99.9,
                default=95)
            private$..desc <- jmvcore::OptionBool$new(
                "desc",
                desc,
                default=FALSE)
            private$..plots <- jmvcore::OptionBool$new(
                "plots",
                plots,
                default=FALSE)

            self$.addOption(private$..vars)
            self$.addOption(private$..ciWidth)
            self$.addOption(private$..desc)
            self$.addOption(private$..plots)
        }),
    active = list(
        vars = function() private$..vars$value,
        ciWidth = function() private$..ciWidth$value,
        desc = function() private$..desc$value,
        plots = function() private$..plots$value),
    private = list(
        ..vars = NA,
        ..ciWidth = NA,
        ..desc = NA,
        ..plots = NA)
)

jmvreliResults <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "jmvreliResults",
    inherit = jmvcore::Group,
    active = list(
        text = function() private$.items[["text"]],
        icctab = function() private$.items[["icctab"]],
        vartab = function() private$.items[["vartab"]],
        plots = function() private$.items[["plots"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="Reliability Analysis")
            self$add(jmvcore::Preformatted$new(
                options=options,
                name="text",
                refs=list(
                    "SimplyAgree")))
            self$add(jmvcore::Table$new(
                options=options,
                name="icctab",
                title="Intraclass Correlation Coefficients",
                rows=6,
                columns=list(
                    list(
                        `name`="model", 
                        `title`="model", 
                        `type`="text"),
                    list(
                        `name`="measures", 
                        `title`="measures"),
                    list(
                        `name`="type", 
                        `title`="type", 
                        `type`="text"),
                    list(
                        `name`="icc", 
                        `title`="ICC", 
                        `type`="number"),
                    list(
                        `name`="lower.ci", 
                        `title`="lower.ci", 
                        `type`="number"),
                    list(
                        `name`="upper.ci", 
                        `title`="upper.ci", 
                        `type`="number"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="vartab",
                title="Variance Components",
                visible="(desc)",
                rows=4,
                columns=list(
                    list(
                        `name`="comp", 
                        `title`="Component", 
                        `type`="text"),
                    list(
                        `name`="variance", 
                        `title`="Variance"),
                    list(
                        `name`="percent", 
                        `title`="Percent", 
                        `type`="number"))))
            self$add(jmvcore::Image$new(
                options=options,
                name="plots",
                title="Plot Reliability Data",
                visible="(plots)",
                renderFun=".plot",
                width=450,
                height=400))}))

jmvreliBase <- if (requireNamespace("jmvcore", quietly=TRUE)) R6::R6Class(
    "jmvreliBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = "SimplyAgree",
                name = "jmvreli",
                version = c(1,0,0),
                options = options,
                results = jmvreliResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = FALSE,
                requiresMissings = FALSE)
        }))

#' Reliability Analysis
#'
#' 
#' @param data the data as a data frame
#' @param vars a list of the column names containing the measurements for
#'   reliability analysis.
#' @param ciWidth a number between 50 and 99.9 (default: 95), the width of
#'   confidence intervals
#' @param desc \code{TRUE} or \code{FALSE} (default), provide table of
#'   variance components
#' @param plots \code{TRUE} or \code{FALSE} (default), plot data
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$text} \tab \tab \tab \tab \tab a preformatted \cr
#'   \code{results$icctab} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$vartab} \tab \tab \tab \tab \tab a table \cr
#'   \code{results$plots} \tab \tab \tab \tab \tab an image \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$icctab$asDF}
#'
#' \code{as.data.frame(results$icctab)}
#'
#' @export
jmvreli <- function(
    data,
    vars,
    ciWidth = 95,
    desc = FALSE,
    plots = FALSE) {

    if ( ! requireNamespace("jmvcore", quietly=TRUE))
        stop("jmvreli requires jmvcore to be installed (restart may be required)")

    if ( ! missing(vars)) vars <- jmvcore::resolveQuo(jmvcore::enquo(vars))
    if (missing(data))
        data <- jmvcore::marshalData(
            parent.frame(),
            `if`( ! missing(vars), vars, NULL))


    options <- jmvreliOptions$new(
        vars = vars,
        ciWidth = ciWidth,
        desc = desc,
        plots = plots)

    analysis <- jmvreliClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}

