% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ss.data.pb2}
\alias{ss.data.pb2}
\title{Particle Boards Example - by Groups}
\format{A data frame with 100 observations on the following 2 variables.
  \describe{
    \item{\code{pb.group}}{a numeric vector}
    \item{\code{pb.humidity}}{a numeric vector}
  }}
\source{
See references.
}
\usage{
data(ss.data.pb2)
}
\description{
Humidity of 20 groups of size 5 of raw materials to make particle boards. For the mean and range control chart.
}
\note{
This data set is used in chapter 12 of the book ``Six Sigma with R'' (see 
References).
}
\examples{
data(ss.data.pb2)
summary(ss.data.pb2)
if (require(qcc)){
  pb.groups.xbar <- with(ss.data.pb2, qcc.groups(pb.humidity, pb.group))
  pb.xbar <- qcc(pb.groups.xbar, type="xbar")
  summary(pb.xbar)
} else {
message("qcc package is needed to run this example")
}

}
\references{
Cano, Emilio L., Moguerza, Javier M. and Redchuk, Andrés. 2012.
\emph{Six Sigma with {R}. Statistical Engineering for Process
  Improvement}, Use R!, vol. 36. Springer, New York.
  \url{http://www.springer.com/statistics/book/978-1-4614-3651-5}.\cr
}
\keyword{cc}
\keyword{data}

