% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F_features_daily.R
\name{calc_featuresda_consumption}
\alias{calc_featuresda_consumption}
\title{Calculates consumption features from daily smart meter data}
\usage{
calc_featuresda_consumption(
  B,
  rowname = NULL,
  featsCoarserGranularity = FALSE,
  replace_NA_with_defaults = TRUE
)
}
\arguments{
\item{B}{a vector with length 7 measurements}

\item{rowname}{the row name of the resulting feature vector}

\item{featsCoarserGranularity}{are the features of finer granularity levels also to be calculated (TRUE/FALSE)}

\item{replace_NA_with_defaults}{replaces missing (NA) or infinite values that may appear during calculation
with default values}
}
\value{
a data.frame with the calculated features as columns and a specified
   rowname, if given
}
\description{
Calculates consumption features from daily smart meter data
}
\references{
Hopf, K. (2019). Predictive Analytics for Energy Efficiency and
    Energy Retailing (1st ed.). Bamberg: University of Bamberg.
    \url{https://doi.org/10.20378/irbo-54833}
}
\author{
Konstantin Hopf \email{konstantin.hopf@uni-bamberg.de}
}
