% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pddply.R
\name{pddply}
\alias{pddply}
\title{Parallel wrapper for plyr::ddply}
\usage{
pddply(.data, .variables, .fun = NULL, ..., njobs = parallel::detectCores()
  - 1, .progress = "none", .inform = FALSE, .drop = TRUE,
  .paropts = NULL)
}
\arguments{
\item{.data}{data frame to be processed}

\item{.variables}{character vector of variables in \code{.data} that will define how to split the data}

\item{.fun}{function to apply to each piece}

\item{\dots}{other arguments passed on to '.fun'}

\item{njobs}{the number of parallel jobs to launch, defaulting to one less than the number of available cores on the machine}

\item{.progress}{name of the progress bar to use, see \code{\link[plyr:create_progress_bar]{plyr::create_progress_bar}}}

\item{.inform}{produce informative error messages?  This is turned off by default because it substantially
slows processing speed, but is very useful for debugging}

\item{.drop}{should combinations of variables that do not appear in the input data be
preserved (FALSE) or dropped (TRUE, default)}

\item{.paropts}{a list of additional options passed into the \code{\link[foreach:foreach]{foreach::foreach}} function
when parallel computation is enabled.  This is important if (for example) your code relies on external data
or packages. Use the \code{.export} and \code{.packages} arguments to
supply them so that all cluster nodes have the correct environment set up for computing.}
}
\value{
The object data frame returned by \code{\link[plyr:ddply]{plyr::ddply}}
}
\description{
Parallel implementation of \code{\link[plyr:ddply]{plyr::ddply}} that suppresses a spurious warning when
\code{\link[plyr:ddply]{plyr::ddply}} is called in parallel.
All of the arguments except \code{njobs} are passed directly to arguments of the same name in
\code{\link[plyr:ddply]{plyr::ddply}}.
}
\details{
An innocuous warning is thrown when \code{\link[plyr:ddply]{plyr::ddply}} is called in parallel:
\url{https://github.com/hadley/plyr/issues/203}.  This function catches and hides that warning, which looks like this:
\verb{

Warning messages:
1: <anonymous>: ... may be used in an incorrect context: '.fun(piece, ...)'
}

If \code{njobs = 1}, a call to \code{\link[plyr:ddply]{plyr::ddply}} is made without parallelization, and anything
supplied to \code{.paropts} is ignored. See the documentation for \code{\link[plyr:ddply]{plyr::ddply}} for additional details.
}
\examples{
data(baseball, package = "plyr")

\donttest{
# Summarize the number of entries for each year in the baseball dataset with 2 jobs
o1 <- pddply(baseball, ~ year, nrow, njobs = 2)
head(o1)

#  Verify it's the same as the non-parallel version of plyr::ddply()
o2 <- plyr::ddply(baseball, ~ year, nrow)
identical(o1, o2)


# Another possibility
o3 <- pddply(baseball, "lg", c("nrow", "ncol"), njobs = 2)
o3

o4 <- plyr::ddply(baseball, "lg", c("nrow", "ncol"))
identical(o3, o4)
}

# A nonsense example where we need to pass objects and packages into the cluster
number1 <- 7

f <- function(x, number2 = 10) {
 paste(x$id[1], padZero(number1, num = 2), number2, sep = "-")
}

# In parallel
o5 <- pddply(baseball[1:100,], "year", f, number2 = 13, njobs = 2,
            .paropts = list(.packages = "Smisc", .export = "number1"))
o5

\donttest{
# Non parallel
o6 <- plyr::ddply(baseball[1:100,], "year", f, number2 = 13)
identical(o5, o6)
}
}
\seealso{
\code{\link[plyr:ddply]{plyr::ddply}}
}
