% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plapply.R
\name{plapply}
\alias{plapply}
\title{Simple parallelization of lapply}
\usage{
plapply(X, FUN, ..., njobs = parallel::detectCores() - 1, packages = NULL,
  header.file = NULL, needed.objects = NULL,
  needed.objects.env = parent.frame(), workDir = "plapply",
  clobber = TRUE, max.hours = 24, check.interval.sec = 1,
  collate = FALSE, random.seed = NULL, rout = NULL, clean.up = TRUE,
  verbose = FALSE)
}
\arguments{
\item{X}{A list or vector, each element of which will be the input to \code{FUN}}

\item{FUN}{A function whose first argument is an element of \code{X}}

\item{\dots}{Additional named arguments to \code{FUN}}

\item{njobs}{The number of jobs (subsets).  Defaults to one less than the
number of cores on the machine.}

\item{packages}{Character vector giving the names of packages that will be
loaded in each new instance of R, using \code{\link{library}}.}

\item{header.file}{Text string indicating a file that will be initially
sourced prior calling \code{\link{lapply}} in order to create an
'environment' that will satisfy all potential dependencies for \code{FUN}.
If \code{NULL}, no file is sourced.}

\item{needed.objects}{Character vector giving the names of objects which
reside in the evironment specified by \code{needed.objects.env} that may be
needed by \code{FUN} which are loaded into the global environment of each
new instance of R that is launched.  If \code{NULL}, no additional objects
are passed.}

\item{needed.objects.env}{Environment where \code{needed.objects} reside.
This defaults to the environment in which \code{plapply} is called.}

\item{workDir}{Character string giving the name of the working directory that
will be used for for the files needed to launch the separate instances of R.}

\item{clobber}{Logical indicating whether the directory designated by \code{workDir}
will be overwritten if it exists and contains files.  If \code{clobber = FALSE},
and \code{workDir} contains files, \code{plapply} throws an error.}

\item{max.hours}{The maximum number of hours to wait for the \code{njobs}
to complete.}

\item{check.interval.sec}{The number of seconds to wait between checking to
see whether all \code{njobs} have completed.}

\item{collate}{\code{= TRUE} creates a 'first-in-first-out' processing order of
the elements of the input list \code{X}.  This logical is passed to the
\code{collate} argument of \code{\link{parseJob}}.}

\item{random.seed}{An integer setting the random seed, which will result in
randomizing the elements of the list assigned to each job. This is useful
when the computing time for each element varies significantly because it
helps to even out the run times of the parallel jobs. If \code{random.seed
= NULL}, no randomization is performed and the elements of the input list
are subdivided sequentially among the jobs.  This variable is passed to the
\code{random.seed} argument of \code{\link{parseJob}}. If \code{collate = TRUE},
no randomization is performed and \code{random.seed} is ignored.}

\item{rout}{A character string giving the name of the file to where all of the \code{.Rout} files
will be gathered.  If \code{rout = NULL}, the \code{.Rout} files are not gathered, but left
alone in \code{workDir}.}

\item{clean.up}{\code{= TRUE} will delete the working directory.}

\item{verbose}{\code{= TRUE} prints messages which show the progress of the
jobs.}
}
\value{
A list equivalent to that returned by \code{lapply(X, FUN, ...)}.
}
\description{
Parses a large list into subsets and submits a separate batch R job that calls \code{\link{lapply}}
on the  subset.  \code{plapply} has some features that may not be readily available in
other parallelization functions like \code{\link{mclapply}} and \code{\link{parLapply}}:
\itemize{
\item The \code{.Rout} files produced by each R instance are easily accessible
for convenient debugging of errors or warnings.  The \code{.Rout} files
can also serve as an explicit record of the work that
was performed by the workers
\item Three options are available for the ordering of the processing of the list elements:
the original list order, randomized, or collated (first-in-first-out).
\item In each R instance, pre-processing or post-processing steps can be performed
before and after the call to \code{\link{lapply}}}
These pre-processing and post-processing steps can depend
on the instance of R, such that each instance can be treated differently, if desired.
These features give greater control over the computing process, which can be especially useful for large jobs.
}
\details{
\code{plapply} applies \code{FUN} to each element of the list \code{X} by
parsing the list into \code{njobs} lists of equal (or almost equal) size
and then applies \code{FUN} to each sublist using \code{\link{lapply}}.

A separate batch instance of R is launched for each sublist, thus utilizing
another core of the machine. After the jobs complete, the \code{njobs}
output lists are reassembled. The global environments for each batch instance
of R are created by writing/reading data to/from disc.

If \code{collate = TRUE} or \code{random.seed = Integer value}, the output
list returned by \code{plapply} is reordered to reflect the original
ordering of the input list, \code{X}.

An object called \code{process.id} (consisting of an integer indicating the
process number) is available in the global environment of each instance of
R.

Each instance of R runs a script that performs the following steps:

\enumerate{

\item Any other packages indicated in the \code{packages} argument are
loaded via calls to \code{library()}

\item The \code{process.id} global variable is assigned to the global
environment of the R instance (having been passed
in via a command line argument)

\item The header file (if there is one) is sourced

\item The expression \code{pre.process.expression} is evaluated if an
object of that name is present in the global environment. The object
\code{pre.process.expression} may be passed in via the header file or via
\code{needed.objects}

\item \code{\link{lapply}} is called on the sublist, the sublist is called
\code{X.i}

\item The expression \code{post.process.expression} is evaluated if an
object of that name is present in the global environment.  The object
\code{post.process.expression} may be passed in via the header file or via
\code{needed.objects}

\item The output returned by \code{lapply} is assigned to the object
\code{X.i.out}, and is saved to a temporary file
where it will be collected after all jobs have completed

\item Warnings are printed
}

If \code{njobs = 1}, none of the previous steps are executed, only this
call is made:  \code{lapply(X, FUN, ...)}
}
\examples{
# Create a simple list
a <- list(a = rnorm(10), b = rnorm(20), c = rnorm(15), d = rnorm(13),
          e = rnorm(15), f = rnorm(22))

# Some objects that will be needed by f1:
b1 <- rexp(20)
b2 <- rpois(10, 20)

# The function
f1 <- function(x) mean(x) + max(b1) - min(b2)

# Call plapply
res1 <- plapply(a, f1, njobs = 2, needed.objects = c("b1", "b2"),
                check.interval.sec = 0.5, max.hours = 1/120,
                workDir = "example1", rout = "example1.Rout",
                clean.up = FALSE)

print(res1)

# Look at the collated 'Rout' file
more("example1.Rout")

# Look at the contents of the working directory
dir("example1")

# Remove working directory and Rout file
unlink("example1", recursive = TRUE, force = TRUE)
unlink("example1.Rout")
 
# Verify the result with lapply
res2 <- lapply(a, f1)

# Compare results
identical(res1, res2)
}
\seealso{
\code{\link{parLapplyW}}, \code{\link{dfplapply}}, \code{\link{parLapply}}, \code{\link{mclapply}}
}
\author{
Landon Sego
}
\keyword{misc}
