% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.idm.R
\name{plot.idm}
\alias{plot.idm}
\title{Plot method for an illness-death model}
\usage{
\method{plot}{idm}(
  x,
  conf.int = FALSE,
  citype = "shadow",
  add = FALSE,
  axes = TRUE,
  col,
  lwd,
  lty,
  xlim,
  ylim,
  xlab,
  ylab,
  legend = TRUE,
  transition = c("01", "02", "12"),
  ...
)
}
\arguments{
\item{x}{a \code{idmWeib} class object (output from calling
\code{idm} with the (default) option \code{intensities}="Weib".}

\item{conf.int}{If TRUE show confidence limits}

\item{citype}{Type of confidence limits, can be "shadow" or "bars"}

\item{add}{If TRUE add to existing plot}

\item{axes}{If TRUE axes are drawn}

\item{col}{Color of the lines}

\item{lwd}{Width of the lines}

\item{lty}{Type of the lines}

\item{xlim}{Limits for x-axis}

\item{ylim}{Limits for y-axis}

\item{xlab}{Label for x-axis}

\item{ylab}{Label for y-axis}

\item{legend}{If TRUE a legend is drawn, which can be further controlled via \code{\link{SmartControl}}.}

\item{transition}{Choose one of the transition intensities: \code{c("01","02","12")}.}

\item{...}{Passed to \code{\link{SmartControl}}}
}
\value{
Print a plot of the baseline transition intensities of an
illness-death model estimated using a Weibull approach.
}
\description{
Plot estimated baseline transition intensities from an object of class
\code{idm} optionally with confidence limits.
}
\examples{

library(lava)
library(prodlim)
m <- idmModel(scale.lifetime=1/10,scale.illtime=1/8)
distribution(m,"X") <- binomial.lvm()
regression(m,latent.lifetime~X) <- 0.7
set.seed(30)
d <- sim(m,100)
fit.weib <- idm(formula02=Hist(observed.lifetime,event=seen.exit)~1,
formula01=Hist(time=list(L,R),event=seen.ill)~1,data=d,conf.int=FALSE)
plot(fit.weib)

\dontrun{
## FIXME: the limits for the 01 transition are a bit wide!?
## with bootstrap confidence limits
fit.weib <- idm(formula02=Hist(observed.lifetime,event=seen.exit)~1,
formula01=Hist(time=list(L,R),event=seen.ill)~1,data=d,conf.int=TRUE)
plot(fit.weib)
}
 

}
\seealso{
\code{\link{print.idm}},\code{\link{summary.idm}},\code{\link{idm}},

\code{\link{idm}}
}
\keyword{methods}
