% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Collect.R
\name{Collect}
\alias{Collect}
\title{Collect data from social media for generating networks}
\usage{
Collect(credential, ego = FALSE, ...)
}
\arguments{
\item{credential}{\code{credential} object generated from
\code{Authenticate}}

\item{ego}{logical, collecting ego network data. Currently only support
Instagram.}

\item{...}{additional parameters for data collection (refer to
CollectDataFrom* and CollectEgo* functions)

\code{facebook}: pageName, rangeFrom, rangeTo, verbose, n, writeToFile,
dynamic

\code{youtube}: videoIDs, verbose, writeToFile, maxComments

\code{twitter}: searchTerm, numTweets, verbose, writeToFile, language

\code{instagram}: credential, tag, n, lat, lng, distance, folder, mindate,
maxdate, verbose, sleep, writeToFile, waitForRateLimit

\code{instagram} with \code{ego} = TRUE: username, userid, verbose,
degreeEgoNet, waitForRateLimit, getFollows}
}
\value{
A data.frame object of class \code{dataSource.*} that can be used
with \code{Create}.
}
\description{
This function collects data from social media APIs, and structures the data
into a data frame of class \code{dataSource.*}, ready for creating networks
for further analysis. \code{Collect} is the second step of the
\code{Authenticate}, \code{Collect}, \code{Create} workflow. This function is
a convenient UI wrapper to the core CollectDataFrom* family of functions.
}
\examples{

\dontrun{
require(magrittr)
## Instagram ego network example
myAppID <- "123456789098765"
myAppSecret <- "abc123abc123abc123abc123abc123ab"
myUsernames <- c("senjohnmccain","obama")

Authenticate("instagram",
appID = myAappId,
appSecret = myAppSecret) \%>\% Collect(ego = TRUE,
username = myUsernames) \%>\% Create

## YouTube actor network example
my_apiKeyYoutube <- "314159265358979qwerty"
videoIDs <- c("W2GZFeYGU3s","mL27TAJGlWc")

Authenticate("youtube",
apiKey = my_apiKeyYoutube) \%>\% Collect(videoIDs = videoIDs) \%>\% Create('actor')
}
}
\author{
Chung-hong Chan <chainsawtiney@gmail.com>
}
\seealso{
\code{CollectDataFromFacebook},
\code{CollectDataFromInstagram},
\code{CollectDataFromYoutube}, \code{CollectDatFromTwitter},
\code{CollectEgoInstagram}
}

