% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genericFunctions.R
\name{getC}
\alias{getC}
\title{Calculates the content of the pools}
\usage{
getC(object, as.closures = F)
}
\arguments{
\item{object}{A modelrun as produced by the constructors: 
 \code{\link{Model}},
 \code{\link{Model_by_PoolNames}},
 \code{\link{Model_14}}
the function \code{\link{GeneralModel}} or the functions listed in 
\code{\link{predefinedModels}}. \cr
A model represents the initial value problem (IVP)  
for the contents of the pool consisting of 
\itemize{
 \item{ The initial values of the pool content}
 \item{ The system of ordinary differential equations, as dictated by the fluxes}
 \item{ The times for which the solution of the IVP is evaluated.}
}}

\item{as.closures}{see method arguments}
}
\value{
A matrix with m columns representing where m is the number of pools, and n rows where n is the number times 
as specified by the \code{times} of the model.
}
\description{
This function computes the content of the pools as function of time.
In the original (and most of the present) Models these are Carbon pools hence the name.
Have a look at the methods for details.
}
\section{S4-methods}{
      \itemize{
        \item \code{\link{getC,Model-method}}
        \item \code{\link{getC,Model_by_PoolNames-method}}
        \item \code{\link{getC,NlModel-method}}
      }
}
