% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adat2eSet.R
\name{adat2eSet}
\alias{adat2eSet}
\title{Convert ADAT to ExpressionSet Object}
\usage{
adat2eSet(adat)
}
\arguments{
\item{adat}{A \code{soma_adat} class object as read into the R
environment using \code{\link[=read_adat]{read_adat()}}.}
}
\value{
A Bioconductor object of class \code{ExpressionSet}.
}
\description{
Utility to convert a SomaLogic \code{soma_adat} object to an
\code{ExpressionSet} object via the \pkg{Biobase} package
from \strong{Bioconductor}:
\url{https://www.bioconductor.org/packages/release/bioc/html/Biobase.html}.
}
\details{
The \pkg{Biobase} package is required and must be installed from
\strong{Bioconductor} via the following at the R console:

\if{html}{\out{<div class="sourceCode">}}\preformatted{if (!requireNamespace("BiocManager", quietly = TRUE)) \{
  install.packages("BiocManager")
\}
BiocManager::install("Biobase", version = remotes::bioc_version())
}\if{html}{\out{</div>}}
}
\examples{
eSet <- adat2eSet(example_data)
class(eSet)
eSet

ft <- Biobase::exprs(eSet)
head(ft[, 1:10L], 10L)
}
\references{
\url{https://bioconductor.org/install/}
}
\seealso{
Other eSet: 
\code{\link{pivotExpressionSet}()}
}
\author{
Stu Field
}
\concept{eSet}
