% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainFunctions.R
\name{sourceUnionCytoscape}
\alias{sourceUnionCytoscape}
\title{Visualize in Cytoscape the graphical union induced by the source sets of a collection of graphs}
\usage{
sourceUnionCytoscape(sourceObj, name.graphs = names(sourceObj),
  collection.name = "SourceSetUnion",
  network.name = "UnionSourceSetsGraph", map.name.variable = NULL,
  method = "bonferroni", complete.edges = TRUE,
  return.unionGraph = FALSE)
}
\arguments{
\item{sourceObj}{a \code{SourceSetObj} objects, i.e. the output of the \code{\link[SourceSet]{sourceSet}} function.}

\item{name.graphs}{the names of the graphs to be visualized. Default value is \code{names(sourceObj)}. NOTE: even if a subset of graphs are selected in \code{name.graphs}, the returned statistics are always calculated on the entire collection in the \code{sourceObj} argument.}

\item{collection.name}{name of the collection of graphs displayed in Cytoscape.}

\item{network.name}{name of the resulting union graph.}

\item{map.name.variable}{a list of customized labels to be associated with the names of the genes. Each list element must contain only one value (i.e. the new label), and the name of each element must be associated with the names of the genes given as input to the \code{\link[SourceSet]{sourceSet}} function (column names of \code{data} input argument). If a label is not mapped, the original name is used.}

\item{method}{correction method for p-values calculated on graphs. The adjustment methods allowed are: \code{fdr} (default), \code{holm}, \code{hochberg}, \code{hommel}, \code{bonferroni}, \code{BH}, \code{BY} or \code{none}. For more details refer to \code{\link[stats]{p.adjust}}.}

\item{complete.edges}{if \code{TRUE}, the graphs selected in \code{name.graphs} are merged and the induced graph of the variables that appear at least in a source set is returned. if \code{FALSE}, the subgraph induced by the variables in the source set of each graph specified in \code{name.graphs} is found, and their union is returned.}

\item{return.unionGraph}{if \code{TRUE}, the function returns the data frame of the edges of the resulting union graph, together with information about the variables obtained internally through the \code{\link[SourceSet]{infoSource}} function.}
}
\description{
The function, thanks to the connection with the Cytoscape software, allows the user to create the graphical union induced by the source sets of a collection of graphs to be visualized in a unique session, while documenting interesting findings.
}
\details{
The visual node attributes size and fill color are defined in a dynamic manner through a visual mapping based on the indices provided by the \code{\link[SourceSet]{infoSource}} function (automatically uploaded in the bottom panel - right side).

A continous mapper between \code{sub.n.source} attribute and size is applied: higher values are represented with bigger nodes.
On the other hand, a color gradient mapper between fill node color and \code{relevance} is adopted: higher values are highlighted with darker blue color.

The edges connecting nodes belonging to the graph induced by the source set of each graph are represented by a solid line; while, the edges that connect two variables linked in the union of the graphs, but not within the same source set of a single graph, have dotted lines (supplied only if \code{complete.edges=TRUE}).

The default style can be changed manually either within Cytoscape (for further information see \href{http://manual.cytoscape.org/en/stable/Styles.html}{manual}) or within an R package \code{r2cytoscape} through network SUID returned by the \code{sourceCytoscape} function (for further details see \href{https://github.com/cytoscape/r2cytoscape}{manual}).

It is also possible to call the sourceCytoscape function multiple times, with all the graphs being visualized in a unique session within a collection specified by collection.name.
}
\note{
The function use the \code{r2cytoscape} package to connect to Cytoscape from R using CyREST. \code{r2cytoscape} can be downloaded from:
\itemize{
   \item{Bioconductor: \code{biocLite("r2cytoscape")};}
   \item{GitHub: \code{install_github("cytoscape/r2cytoscape")}.}
}

To enable the display function to work properly, three simple steps are required:
\itemize{
   \item{ Download \href{http://www.cytoscape.org/download.php}{Cytoscape} (version 3.3 or later);}
   \item{ Complete installation wizard;}
   \item{ Launch Cytoscape (before calling the functions).}
}
}
\examples{
## Load the SourceSetObj obtained from the source set analysis of ALL dataset

# see vignette for more details
print(load(file=system.file("extdata","ALLsourceresult.RData",package = "SourceSet")))
class(results.all)

## NB: Remember to launch cytoscape before running the following commands
# Create two collections of pathways to visualize the results
graph.signaling<-names(results.all)[grep("signaling",names(results.all))]
graph.other<-setdiff(names(results.all),graph.signaling)

## Signaling collection
\donttest{
cytoID.signaling.union<-sourceUnionCytoscape(results.all,
      name.graphs =graph.signaling ,collection.name ="SignalingPathway",
      network.name ="SignalingUnion")
}
## Other collection
\donttest{
cytoID.other.union<-sourceUnionCytoscape(results.all ,
      name.graphs =graph.other,collection.name ="OtherPathway" ,
      network.name ="OtherUnion")
}
}
\seealso{
\code{\link[SourceSet]{sourceSet}}, \code{\link[SourceSet]{sourceCytoscape}}, \code{r2cytoscape}
}
