% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc-methods.R
\name{setPaths}
\alias{setPaths}
\alias{.paths}
\alias{getPaths}
\alias{setPaths}
\title{Get and set default working directories}
\usage{
.paths()

getPaths()

setPaths(cachePath, inputPath, modulePath, outputPath)
}
\arguments{
\item{cachePath}{The default local directory in which to cache simulation outputs.
If not specified, defaults to \code{getOption("spades.cachePath")}.}

\item{inputPath}{The default local directory in which to look for simulation inputs
If not specified, defaults to \code{getOption("spades.inputPath")}.}

\item{modulePath}{The default local directory where modules and data will be
downloaded and stored.
If not specified, defaults to \code{getOption("spades.modulePath")}.}

\item{outputPath}{The default local directory in which to save simulation outputs.
If not specified, defaults to \code{getOption("spades.outputPath")}.}
}
\value{
Returns a named list of the user's default working directories.
\code{setPaths} is invoked for the side effect of setting these directories.
}
\description{
Wrapper functions to access the packages options for default working directories.
}
\examples{
\dontrun{
getPaths()                       ## returns the current default working paths
setPaths(cachePath = tempdir())  ## sets custom cachePath with other paths default
setPaths(inputPath = tempdir())  ## sets custom inputPath with other paths default
setPaths(modulePath = tempdir()) ## sets custom modulePath with other paths default
setPaths(outputPath = tempdir()) ## sets custom outputPath with other paths default
}

}
\author{
Alex Chubaty
}
\keyword{internal}
