% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simList-accessors.R
\docType{methods}
\name{createsOutput}
\alias{createsOutput}
\alias{createsOutput,ANY,ANY,ANY-method}
\alias{createsOutput,character,character,character-method}
\title{Define an output object of a module}
\usage{
createsOutput(objectName, objectClass, desc, ...)

\S4method{createsOutput}{ANY,ANY,ANY}(objectName, objectClass, desc, ...)

\S4method{createsOutput}{character,character,character}(objectName, objectClass,
  desc, ...)
}
\arguments{
\item{objectName}{Character string to define the output object's name.}

\item{objectClass}{Character string to specify the output object's class.}

\item{desc}{Text string providing a brief description of the output object.}

\item{...}{Other specifications of the output object.}
}
\value{
A \code{data.frame} suitable to be passed to \code{outputObjects} in
a module's metadata.
}
\description{
Used to specify an output object's name, class, description and other specifications.
}
\examples{
outputObjects <- dplyr::bind_rows(
  createsOutput(objectName = "outputObject1", objectClass = "character",
                desc = "this is for example"),
  createsOutput(objectName = "outputObject2", objectClass = "numeric",
                desc = "this is for example",
                otherInformation = "I am the second output object")
)

}
\author{
Yong Luo
}

