% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R, R/stats.R
\docType{methods}
\name{corr}
\alias{corr}
\alias{corr}
\alias{corr,Column-method}
\alias{corr}
\alias{corr,SparkDataFrame-method}
\title{corr}
\usage{
corr(x, ...)

\S4method{corr}{Column}(x, col2)

\S4method{corr}{SparkDataFrame}(x, colName1, colName2, method = "pearson")
}
\arguments{
\item{x}{a Column or a SparkDataFrame.}

\item{...}{additional argument(s). If \code{x} is a Column, a Column
should be provided. If \code{x} is a SparkDataFrame, two column names should
be provided.}

\item{col2}{a (second) Column.}

\item{colName1}{the name of the first column}

\item{colName2}{the name of the second column}

\item{method}{Optional. A character specifying the method for calculating the correlation.
only "pearson" is allowed now.}
}
\value{
The Pearson Correlation Coefficient as a Double.
}
\description{
Computes the Pearson Correlation Coefficient for two Columns.

Calculates the correlation of two columns of a SparkDataFrame.
Currently only supports the Pearson Correlation Coefficient.
For Spearman Correlation, consider using RDD methods found in MLlib's Statistics.
}
\note{
corr since 1.6.0

corr since 1.6.0
}
\examples{
\dontrun{corr(df$c, df$d)}
\dontrun{
df <- read.json("/path/to/file.json")
corr <- corr(df, "title", "gender")
corr <- corr(df, "title", "gender", method = "pearson")
}
}
\seealso{
Other math_funcs: \code{\link{acos}}, \code{\link{asin}},
  \code{\link{atan2}}, \code{\link{atan}},
  \code{\link{bin}}, \code{\link{bround}},
  \code{\link{cbrt}}, \code{\link{ceil}},
  \code{\link{conv}}, \code{\link{cosh}},
  \code{\link{cos}}, \code{\link{covar_pop}},
  \code{\link{cov}}, \code{\link{expm1}},
  \code{\link{exp}}, \code{\link{factorial}},
  \code{\link{floor}}, \code{\link{hex}},
  \code{\link{hypot}}, \code{\link{log10}},
  \code{\link{log1p}}, \code{\link{log2}},
  \code{\link{log}}, \code{\link{pmod}},
  \code{\link{rint}}, \code{\link{round}},
  \code{\link{shiftLeft}},
  \code{\link{shiftRightUnsigned}},
  \code{\link{shiftRight}}, \code{\link{signum}},
  \code{\link{sinh}}, \code{\link{sin}},
  \code{\link{sqrt}}, \code{\link{tanh}},
  \code{\link{tan}}, \code{\link{toDegrees}},
  \code{\link{toRadians}}, \code{\link{unhex}}

Other stat functions: \code{\link{approxQuantile}},
  \code{\link{cov}}, \code{\link{crosstab}},
  \code{\link{freqItems}}, \code{\link{sampleBy}}
}
