% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/functions.R
\name{column_nonaggregate_functions}
\alias{column_nonaggregate_functions}
\alias{lit,ANY-method}
\alias{lit}
\alias{bitwiseNOT,Column-method}
\alias{bitwiseNOT}
\alias{coalesce,Column-method}
\alias{isnan,Column-method}
\alias{isnan}
\alias{is.nan,Column-method}
\alias{is.nan}
\alias{monotonically_increasing_id,missing-method}
\alias{monotonically_increasing_id}
\alias{negate,Column-method}
\alias{negate}
\alias{spark_partition_id,missing-method}
\alias{spark_partition_id}
\alias{struct,characterOrColumn-method}
\alias{struct}
\alias{nanvl,Column-method}
\alias{nanvl}
\alias{greatest,Column-method}
\alias{greatest}
\alias{least,Column-method}
\alias{least}
\alias{expr,character-method}
\alias{expr}
\alias{rand,missing-method}
\alias{rand}
\alias{rand,numeric-method}
\alias{randn,missing-method}
\alias{randn}
\alias{randn,numeric-method}
\alias{when,Column-method}
\alias{when}
\alias{ifelse,Column-method}
\alias{ifelse}
\alias{create_array,Column-method}
\alias{create_array}
\alias{create_map,Column-method}
\alias{create_map}
\alias{input_file_name,missing-method}
\alias{input_file_name}
\title{Non-aggregate functions for Column operations}
\usage{
when(condition, value)

bitwiseNOT(x)

create_array(x, ...)

create_map(x, ...)

expr(x)

greatest(x, ...)

input_file_name(x = "missing")

isnan(x)

least(x, ...)

lit(x)

monotonically_increasing_id(x = "missing")

nanvl(y, x)

negate(x)

rand(seed)

randn(seed)

spark_partition_id(x = "missing")

struct(x, ...)

\S4method{lit}{ANY}(x)

\S4method{bitwiseNOT}{Column}(x)

\S4method{coalesce}{Column}(x, ...)

\S4method{isnan}{Column}(x)

\S4method{is.nan}{Column}(x)

\S4method{monotonically_increasing_id}{missing}()

\S4method{negate}{Column}(x)

\S4method{spark_partition_id}{missing}()

\S4method{struct}{characterOrColumn}(x, ...)

\S4method{nanvl}{Column}(y, x)

\S4method{greatest}{Column}(x, ...)

\S4method{least}{Column}(x, ...)

\S4method{expr}{character}(x)

\S4method{rand}{missing}(seed)

\S4method{rand}{numeric}(seed)

\S4method{randn}{missing}(seed)

\S4method{randn}{numeric}(seed)

\S4method{when}{Column}(condition, value)

\S4method{ifelse}{Column}(test, yes, no)

\S4method{create_array}{Column}(x, ...)

\S4method{create_map}{Column}(x, ...)

\S4method{input_file_name}{missing}()
}
\arguments{
\item{condition}{the condition to test on. Must be a Column expression.}

\item{value}{result expression.}

\item{x}{Column to compute on. In \code{lit}, it is a literal value or a Column.
In \code{expr}, it contains an expression character object to be parsed.}

\item{...}{additional Columns.}

\item{y}{Column to compute on.}

\item{seed}{a random seed. Can be missing.}

\item{test}{a Column expression that describes the condition.}

\item{yes}{return values for \code{TRUE} elements of test.}

\item{no}{return values for \code{FALSE} elements of test.}
}
\description{
Non-aggregate functions defined for \code{Column}.
}
\details{
\code{lit}: A new Column is created to represent the literal value.
If the parameter is a Column, it is returned unchanged.

\code{bitwiseNOT}: Computes bitwise NOT.

\code{coalesce}: Returns the first column that is not NA, or NA if all inputs are.

\code{isnan}: Returns true if the column is NaN.

\code{is.nan}: Alias for \link{isnan}.

\code{monotonically_increasing_id}: Returns a column that generates monotonically increasing
64-bit integers. The generated ID is guaranteed to be monotonically increasing and unique,
but not consecutive. The current implementation puts the partition ID in the upper 31 bits,
and the record number within each partition in the lower 33 bits. The assumption is that the
SparkDataFrame has less than 1 billion partitions, and each partition has less than 8 billion
records. As an example, consider a SparkDataFrame with two partitions, each with 3 records.
This expression would return the following IDs:
0, 1, 2, 8589934592 (1L << 33), 8589934593, 8589934594.
This is equivalent to the MONOTONICALLY_INCREASING_ID function in SQL.
The method should be used with no argument.
Note: the function is non-deterministic because its result depends on partition IDs.

\code{negate}: Unary minus, i.e. negate the expression.

\code{spark_partition_id}: Returns the partition ID as a SparkDataFrame column.
Note that this is nondeterministic because it depends on data partitioning and
task scheduling.
This is equivalent to the \code{SPARK_PARTITION_ID} function in SQL.

\code{struct}: Creates a new struct column that composes multiple input columns.

\code{nanvl}: Returns the first column (\code{y}) if it is not NaN, or the second column
(\code{x}) if the first column is NaN. Both inputs should be floating point columns
(DoubleType or FloatType).

\code{greatest}: Returns the greatest value of the list of column names, skipping null values.
This function takes at least 2 parameters. It will return null if all parameters are null.

\code{least}: Returns the least value of the list of column names, skipping null values.
This function takes at least 2 parameters. It will return null if all parameters are null.

\code{expr}: Parses the expression string into the column that it represents, similar to
\code{SparkDataFrame.selectExpr}

\code{rand}: Generates a random column with independent and identically distributed (i.i.d.)
samples uniformly distributed in [0.0, 1.0).
Note: the function is non-deterministic in general case.

\code{randn}: Generates a column with independent and identically distributed (i.i.d.) samples
from the standard normal distribution.
Note: the function is non-deterministic in general case.

\code{when}: Evaluates a list of conditions and returns one of multiple possible result
expressions. For unmatched expressions null is returned.

\code{ifelse}: Evaluates a list of conditions and returns \code{yes} if the conditions are
satisfied. Otherwise \code{no} is returned for unmatched conditions.

\code{create_array}: Creates a new array column. The input columns must all have the same data
type.

\code{create_map}: Creates a new map column. The input columns must be grouped as key-value
pairs, e.g. (key1, value1, key2, value2, ...).
The key columns must all have the same data type, and can't be null.
The value columns must all have the same data type.

\code{input_file_name}: Creates a string column with the input file name for a given row.
The method should be used with no argument.
}
\note{
lit since 1.5.0

bitwiseNOT since 1.5.0

coalesce(Column) since 2.1.1

isnan since 2.0.0

is.nan since 2.0.0

negate since 1.5.0

spark_partition_id since 2.0.0

struct since 1.6.0

nanvl since 1.5.0

greatest since 1.5.0

least since 1.5.0

expr since 1.5.0

rand since 1.5.0

rand(numeric) since 1.5.0

randn since 1.5.0

randn(numeric) since 1.5.0

when since 1.5.0

ifelse since 1.5.0

create_array since 2.3.0

create_map since 2.3.0

input_file_name since 2.3.0
}
\examples{
\dontrun{
# Dataframe used throughout this doc
df <- createDataFrame(cbind(model = rownames(mtcars), mtcars))}

\dontrun{
tmp <- mutate(df, v1 = lit(df$mpg), v2 = lit("x"), v3 = lit("2015-01-01"),
                  v4 = negate(df$mpg), v5 = expr('length(model)'),
                  v6 = greatest(df$vs, df$am), v7 = least(df$vs, df$am),
                  v8 = column("mpg"))
head(tmp)}

\dontrun{
head(select(df, bitwiseNOT(cast(df$vs, "int"))))}

\dontrun{head(select(df, monotonically_increasing_id()))}

\dontrun{head(select(df, spark_partition_id()))}

\dontrun{
tmp <- mutate(df, v1 = struct(df$mpg, df$cyl), v2 = struct("hp", "wt", "vs"),
                  v3 = create_array(df$mpg, df$cyl, df$hp),
                  v4 = create_map(lit("x"), lit(1.0), lit("y"), lit(-1.0)))
head(tmp)}

\dontrun{
tmp <- mutate(df, r1 = rand(), r2 = rand(10), r3 = randn(), r4 = randn(10))
head(tmp)}

\dontrun{
tmp <- mutate(df, mpg_na = otherwise(when(df$mpg > 20, df$mpg), lit(NaN)),
                  mpg2 = ifelse(df$mpg > 20 & df$am > 0, 0, 1),
                  mpg3 = ifelse(df$mpg > 20, df$mpg, 20.0))
head(tmp)
tmp <- mutate(tmp, ind_na1 = is.nan(tmp$mpg_na), ind_na2 = isnan(tmp$mpg_na))
head(select(tmp, coalesce(tmp$mpg_na, tmp$mpg)))
head(select(tmp, nanvl(tmp$mpg_na, tmp$hp)))}

\dontrun{
tmp <- read.text("README.md")
head(select(tmp, input_file_name()))}
}
\seealso{
coalesce,SparkDataFrame-method

Other non-aggregate functions: 
\code{\link{column}()},
\code{\link{not}()}
}
\concept{non-aggregate functions}
