% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eBayes.R
\name{eBayes}
\alias{eBayes}
\title{Empirical Bayes Estimates of Relative Risk}
\usage{
eBayes(Y, E, Xmat = NULL)
}
\arguments{
\item{Y}{a length \code{n} vector of observed cases}

\item{E}{a length \code{n} vector of expected number of cases}

\item{Xmat}{\verb{n x p} dimension matrix of covariates}
}
\value{
A list with 5 elements:
\item{RR}{the ecological relative risk posterior mean estimates}
\item{RRmed}{the ecological relative risk posterior median estimates}
\item{beta}{the MLE's of the regression coefficients}
\item{alpha}{the MLE of negative binomial dispersion parameter}
\item{SMR}{the standardized mortality/morbidity ratio Y/E}
}
\description{
The computes empirical Bayes estimates of relative risk of study region with \code{n} areas, given observed and expected numbers of counts of disease and covariate information.
}
\examples{
data(scotland)
data <- scotland$data
x <- data$AFF
Xmat <- cbind(x,x^2)
results <- eBayes(data$cases,data$expected,Xmat)
scotland.map <- scotland$spatial.polygon
mapvariable(results$RR, scotland.map)
}
\references{
Clayton D. and Kaldor J. (1987) Empirical Bayes estimates of age-standardized relative risks for use in disease mapping.  \emph{Biometrics}, \strong{43}, 671--681
}
