% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iso_spatial_floor.R
\name{iso_spatial_floor}
\alias{iso_spatial_floor}
\title{Isotropic spatial simulation wrapper}
\usage{
iso_spatial_floor(D, cov.var = "exp", nugget = 0, sill, ranges, mu = 0)
}
\arguments{
\item{D}{The distance matrix}

\item{cov.var}{the var-cov function of producing var-cov matrix. 'exp' is exponential, 'gau' is Gaussian}

\item{nugget}{the nugget value of the var-cov function}

\item{sill}{the sill(variance, sigma^2) of the var-cov function}

\item{ranges}{the range value of var-cov function}

\item{mu}{the mean value of the simulated spatial floor}
}
\value{
A vector with the same length of grid floor
}
\description{
This function load grid floor and generate the simulated floor
}
\examples{
D = spatial_dist(expand.grid(1:5, 1:5))
iso_spatial_floor(D, sill=50, ranges=2)
}
