% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contourStewart.R
\name{contourStewart}
\alias{contourStewart}
\title{Create a SpatialPolygonsDataFrame or a SpatialLinesDataFrame from a 
Stewart Raster}
\usage{
contourStewart(x, breaks, mask, type = "line")
}
\arguments{
\item{x}{raster; output of the \code{\link{rasterStewart}} function. The raster must contain only positive values.}

\item{breaks}{numeric; a vector of break values.}

\item{mask}{SpatialPolygonsDataFrame; mask used to clip contour shapes.}

\item{type}{character; "poly" or "line". WARNING: the poly option is experimental (see details). It needs the rgeos package.}
}
\value{
The ouput of the function is a SpatialPolygonsDataFrame (\code{type = "poly"}) or a SpatialLinesDataFrame (\code{type = "line"}).
}
\description{
This function create a SpatialPolygonsDataFrame or SpatialLinesDataFrame contour from the Stewart raster.
}
\details{
To obtain a correct SpatialPolygonsDataFrame of potentials follow theses steps: \itemize{
\item{Step 1: Create a SpatialPointsDataFrame of potentials with the 
stewart function. Do not enter an unknownpts layer, set a resolution, 
and set a SpatialPolygonsDataFrame (spmask) as mask.}
\item{Step 2: Create a raster from the SpatialPointsDataFrame of potentials 
with the rasterStewart function without using a mask.}
\item{Step 3: Create the SpatialPolygonsDataFrame of potential with the 
contourStewart function and use the spamask SpatialPolygonsDataFrame (Step1) as mask.}
}
See also the second example in the examples section.
}
\examples{
#### Example with type = "line"
mystewart <- stewart(knownpts = spatPts, varname = "Capacite",
                     typefct = "exponential", span = 1000, beta = 3,
                     resolution = 50, longlat = FALSE,
                     mask = spatMask)
# Create a raster of potentials values
mystewartraster <- rasterStewart(x = mystewart, mask = spatMask)
# Display the raster and get break values
break.values <- plotStewart(x = mystewartraster)
# Create contour SpatialLinesDataFrame
mystewartcontourpoly <- contourStewart(x = mystewartraster,
                                       breaks = break.values,
                                       type = "line")
# Display the Map
plot(spatMask, add=TRUE)
plot(mystewartcontourpoly, border = "grey40",add = TRUE)
plot(spatPts, cex = 0.8, pch = 20, col  = "black", add = TRUE)



#### Example with type = "poly"
\dontrun{
mystewart <- stewart(knownpts = spatPts, varname = "Capacite",
                     typefct = "exponential", span = 1000, beta = 3,
                     resolution = 50, longlat = FALSE,
                     mask = spatMask)
# Create a raster of potentials valuesn, no mask
mystewartraster <- rasterStewart(x = mystewart)
# Display the raster and get break values
break.values <- plotStewart(x = mystewartraster)
# Create contour SpatialLinesDataFrame
mystewartcontourpoly <- contourStewart(x = mystewartraster,
                                       breaks = break.values,
                                       mask = spatMask,
                                       type = "poly")
# Display the map
library(cartography)
opar <- par(mar = c(0,0,1.1,0))
choroLayer(spdf = mystewartcontourpoly, 
           df = mystewartcontourpoly@data, 
           var = "mean", legend.pos = "topleft",
           breaks = break.values, border = "grey90", 
           lwd = 0.2, 
           legend.title.txt = "Potential number\\nof beds in the\\nneighbourhood", 
           legend.values.rnd = 0)
plot(spatMask, add = TRUE)
propSymbolsLayer(spdf = spatPts, df = spatPts@data, var = "Capacite",
                 legend.title.txt = "Number of beds", 
                 col = "#ff000020")
layoutLayer(title = "Global Accessibility to Public Hospitals", 
            south = TRUE, sources = "", author = "")
par(opar)
}
}
\seealso{
\link{stewart}, \link{rasterStewart}, \link{plotStewart}, \link{contourStewart}, \link{CreateGrid}, \link{CreateDistMatrix}.
}

