% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/isopoly.R
\name{isopoly}
\alias{isopoly}
\title{Create Spatial Polygons Contours from a Raster}
\usage{
isopoly(x, nclass = 8, breaks, mask, xcoords = "COORDX",
  ycoords = "COORDY", var = "OUTPUT", returnclass = "sp")
}
\arguments{
\item{x}{sf POINT data.frame; must contain X, Y and OUTPUT fields.}

\item{nclass}{numeric; a number of class.}

\item{breaks}{numeric; a vector of break values.}

\item{mask}{sf POLYGON data.frame; mask used to 
clip contour shapes.}

\item{xcoords}{character; name of the X coordinates field in x.}

\item{ycoords}{character; name of the Y coordinates field in x.}

\item{var}{character; name of the OUTPUT field in x.}

\item{returnclass}{"sp" or "sf"; class of the returned object.}
}
\value{
The output is an sf POLYGON data.frame.
The data frame contains four fields: 
id (id of each polygon), min and max (minimum and maximum breaks of the polygon), 
center (central values of classes).
}
\description{
This function creates spatial polygons of contours from a raster.
}
\examples{
data(hospital)
# Compute Stewart potentials
mystewart <- stewart(knownpts = hospital, varname = "capacity",
                     typefct = "exponential", span = 1000, beta = 3,
                     mask = paris, returnclass = "sf")
# Create contour
contourpoly <- isopoly(x = mystewart,
                       nclass = 6,
                       mask = paris, returnclass = "sf")
library(sf)
plot(st_geometry(contourpoly))
if(require(cartography)){
  # Created breaks
  bks <- sort(unique(c(contourpoly$min, contourpoly$max)))
  opar <- par(mar = c(0,0,1.2,0))
  # Display the map
  choroLayer(x = contourpoly,
             var = "center", legend.pos = "topleft",
             breaks = bks, border = "grey90",
             lwd = 0.2,
             legend.title.txt = "Potential number\\nof beds in the\\nneighbourhood",
             legend.values.rnd = 0)
  plot(st_geometry(paris), add = TRUE)
  propSymbolsLayer(x = hospital, var = "capacity",
                   legend.pos = "right",
                   legend.title.txt = "Number of beds",
                   col = "#ff000020")
  layoutLayer(title = "Global Accessibility to Public Hospitals",
              sources = "", author = "")
  par(opar)
}
}
\seealso{
\link{stewart}.
}
