% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{hpwd}
\alias{hpwd}
\title{Heuristic Product Within Distance (Spatially Balanced Sampling).}
\usage{
hpwd(dis, nsamp, nrepl = 1L)
}
\arguments{
\item{dis}{A distance matrix NxN that specifies how far are all the pairs of units in the population.}

\item{nsamp}{Sample size.}

\item{nrepl}{Number of samples to draw (default = 1).}
}
\value{
Return a matrix 2x\code{nrepl} with \code{nrepl} samples drawn. In particular, the element \eqn{a_{ij}}{a_ij} is the j-th unit of the population drawn in the i-th sample.
}
\description{
The function \code{hpwd} provides a fast selection of spatially balanced samples: it is a heuristic and a fast implemention of the algorithm \code{\link{pwd}}.
It generates samples approximately with the same probabilities of the \code{\link{pwd}} but with a significantly smaller number of steps.
In fact, this algorithm randomly selects a sample of size \eqn{n} exactly with \eqn{n} steps, updating at each step the selection probability of not-selected units, depending on their distance from the units, that were already selected in the previous steps.
To have constant inclusion probabilities \eqn{\pi_{i}=nsamp/N}, where \eqn{nsamp} is sample size and \eqn{N} is population size, the distance matrix has to be standardized with function \code{\link{stprod}}.
Note that there is a parameter \eqn{\beta} which regulates the spread of the sample: The higher \eqn{\beta} is, the more the sample is going to be spread.
This parameter is regulated by the exponent of the distance matrix (D^1 -> \eqn{\beta = 1}, D^10 -> \eqn{\beta = 10}).
}
\examples{
# Example 1
# Draw 50 samples of dimension 10 without constant probabilities and beta = 1
dis <- as.matrix(dist(cbind(lucas_abruzzo$x, lucas_abruzzo$y))) # distance matrix
samples <- hpwd(dis, 10, 50) # drawn samples
\donttest{
# Example 2
# Draw 100 samples of dimension 15 with constant probabilities equal to nsamp/N and beta = 1
# with N = population size
dis <- as.matrix(dist(cbind(lucas_abruzzo$x, lucas_abruzzo$y))) # distance matrix
vec <- rep(1, nrow(dis)) # vector of constraints
stand_dist <- stprod(dis, vec, 1e-15, 1000) # standardized matrix
samples <- hpwd(stand_dist, 15, 100) # drawn samples

# Example 3
# Draw 100 samples of dimension 15 with constant probabilities equal to nsamp/N and beta = 10
# with N = population size
dis <- as.matrix(dist(cbind(lucas_abruzzo$x, lucas_abruzzo$y))) # distance matrix
dis <- dis^10 # setting beta = 10
vec <- rep(1, nrow(dis)) # vector of constraints
stand_dist <- stprod(dis, vec, 1e-15, 1000) # standardized matrix
samples <- hpwd(stand_dist, 15, 100) # drawn samples
}
}
\references{
\insertRef{BIMJ:BIMJ1785}{Spbsampling}

\insertRef{fast_selection}{Spbsampling}
}
