% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistics_W.R
\name{split_knockoffs.statistics.sign.W_path}
\alias{split_knockoffs.statistics.sign.W_path}
\title{split_knockoffs.statistics.sign.W_path}
\usage{
split_knockoffs.statistics.sign.W_path(X, D, y, nu, option)
}
\arguments{
\item{X}{the design matrix}

\item{D}{the linear transform}

\item{y}{the response vector}

\item{nu}{the parameter for variable splitting}

\item{option}{options for creating the Knockoff statistics
option$eta the choice of eta for creating the knockoff copy
option$lambda the choice of lambda for the path}
}
\value{
W: the knockoff statistics

Z: feature significance

r: the sign estimator

t_Z: knockoff significance
}
\description{
a new method to generate the knockoff statistics W for beta from a split LASSO path
in the intercepetion assignment step, using the method of path order.
}
\examples{
k <- 20   # sparsity level
A <- 1    # magnitude
n <- 350  # sample size
p <- 100  # dimension of variables
c <- 0.5  # feature correlation
sigma <-1 # noise level
option <- array(data = NA, dim = length(data), dimnames = NULL)
option$q <- 0.2
option$eta <- 0.1
option$method <- 'knockoff'
option$stage0 <- 'path'
option$normalize <- 'true'
option$cv_rule <- 'min'
option$lambda <- 10.^seq(0, -6, by=-0.01)
option$nu <- 10
option$copy <- 'true'
option <- option[-1]
# generate D
D <- diag(p)
m <- nrow(D)
# generate X
Sigma = matrix(0, p, p)
for( i in 1: p){
  for(j in 1: p){
    Sigma[i, j] <- c^(abs(i - j))
  }
}
library(mvtnorm)
set.seed(100)
X <- rmvnorm(n,matrix(0, p, 1), Sigma)
# generate beta and gamma
beta_true <- matrix(0, p, 1)
for( i in 1: k){
  beta_true[i, 1] = A
  if ( i\%\%3 == 1){
    beta_true[i, 1] = -A
  }
}
gamma_true <- D \%*\% beta_true
S0 <- which(gamma_true!=0)
# generate varepsilon
set.seed(1)
# generate noise and y
varepsilon <- rnorm(n) * sqrt(sigma)
y <- X \%*\% beta_true + varepsilon
nu = 10
}
