% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecasting_plot.R
\name{forecasting_plot}
\alias{forecasting_plot}
\title{Fanplot for the mortality predictions}
\usage{
forecasting_plot(stan_fit, ages, years, death, exposure, ages.plot)
}
\arguments{
\item{stan_fit}{stanfit object}

\item{ages}{range of ages}

\item{years}{range of years}

\item{death}{matrix of observed deaths}

\item{exposure}{matrix of observed exposures}

\item{ages.plot}{ages to be plotted}
}
\value{
A ggplot object that can be further customized using the \strong{ggplot2} package.
}
\description{
The function generates a fan plot representing the forecast death rates based on the \code{ggplot2} and
\code{ggfan} R packages.
}
\examples{

\donttest{
years <- 1980:2017
ages <- 50:90
death <- FRMaleData$Dxt[formatC(ages),formatC(years)]
exposure <- FRMaleData$Ext[formatC(ages),formatC(years)]
iterations<-1000 # Toy example, consider at least 2000 iterations
fitLC<-lc_stan(death = death,exposure=exposure, forecast = 10,
family = "poisson",chains=1,cores=1,iter=iterations)
forecasting_plot(fitLC,ages,years,death,exposure,c(65,75,85))
}

}
