% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/imputemiss.R
\name{imputemiss}
\alias{imputemiss}
\title{Impute missing values in a variable}
\usage{
imputemiss(vector, value)
}
\arguments{
\item{vector}{a vector with missing values}

\item{value}{the value to be used for imputation}
}
\value{
\code{vector} of the same class as input vector with imputed missing values
}
\description{
Takes in a vector and a value, and returns the vector with missing values imputed
 with that value
}
\details{
\code{imputemiss} imputes the missing (NA) values in the vector with a specified value.
 The function simplifies the code for imputation.
}
\examples{
# Scores vector
scores <- c(1, 2, 3, NA, 4, NA)

# Imputd scores vector
scoresImp <- imputemiss(vector = scores, value = 5)
}
\author{
Akash Jain
}
\seealso{
\code{\link{decile}}, \code{\link{pentile}}, \code{\link{outliers}}
}

