% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_param_xml.R
\name{get_param_xml}
\alias{get_param_xml}
\title{Getting parameter values from xml files}
\usage{
get_param_xml(
  file,
  param = NULL,
  select = NULL,
  select_value = NULL,
  xml_file = lifecycle::deprecated(),
  param_name = lifecycle::deprecated(),
  value = lifecycle::deprecated(),
  ...
)
}
\arguments{
\item{file}{Vector of the xml file paths from which parameters values
must be extracted}

\item{param}{Vector of parameter names. Optional, if not provided, the
function returns information for all parameters.}

\item{select}{node name or attribute name to use for selection
(optional, default to no selection)}

\item{select_value}{Vector of values used for select (see examples).
Optional, should be provided only if select is provided.}

\item{xml_file}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{xml_file} is no
longer supported, use \code{file} instead.}

\item{param_name}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{param_name} is no
longer supported, use \code{param} instead.}

\item{value}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{value} is no
longer supported, use \code{select_value} instead.}

\item{...}{Pass further arguments to \code{get_param_value()}}
}
\value{
A list of parameter values for each xml_file (a list of list)
}
\description{
Extracting parameter values for a list of xml files and
parameters
}
\examples{

# Soil file
file <- file.path(get_examples_path(file_type = "xml"), "sols.xml")

# For all soils
get_param_xml(file)
get_param_xml(file, c("argi", "norg"))

# With soil selection
# scalar parameters per soil
get_param_xml(file, c("argi", "norg"),
  select = "sol", select_value = c("solcanne", "solbanane")
)

# Crop management file
file <- file.path(get_examples_path(file_type = "xml"), "file_tec.xml")

# Getting parameters for irrigation (date and quantity)
get_param_xml(file, c("julapI_or_sum_upvt", "amount"))


}
