% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ornstein_uhlenbeck_sl.R
\name{ornstein_uhlenbeck_sl}
\alias{ornstein_uhlenbeck_sl}
\title{simulate ornstein-uhlenbeck (OU) process (specimen level)}
\usage{
ornstein_uhlenbeck_sl(
  t,
  mu = 0,
  theta = 1,
  sigma = 1,
  y0 = 0,
  intrapop_var = 1,
  n_per_sample = 10
)
}
\arguments{
\item{t}{times at which the process is simulated. Can be heterodistant}

\item{mu}{number, long term mean}

\item{theta}{number, mean reversion speed}

\item{sigma}{positive number, strength of randomness}

\item{y0}{number, initial value (value of process at the first entry of t)}

\item{intrapop_var}{intrapopulation variance, determines how much specimens from the same population vary}

\item{n_per_sample}{integer, number of specimens sampled per population/sampling locality}
}
\value{
an object of S3 class \code{pre_paleoTS}, inherits from \code{timelist} and \code{list}. The list has two elements: \code{t}, containing a vector of times of sampling, and \code{vals}, a list of trait values of the same length as \code{t}, with element containing trait values of individual specimens.  This object can be transformed using \code{apply_taphonomy}, \code{apply_niche} or \code{time_to_strat}, and then reduced to a \code{paleoTS} object using \code{reduce_to_paleoTS}. This can then be used to test for different modes of evolution.
}
\description{
Simulates an Ornstein-Uhlenbeck process on specimen level (_sl). The mean trait value is simulated using the Euler-Maruyama method. The process is simulated on a scale of \code{0.25 * min(diff(t))} and then interpolated to the values of \code{t}. At each sampling location there are \code{n_per_sample} specimens that are normally distributed around the mean trait value with a variance of \code{intrapop_var}.
}
\examples{

library("paleoTS")
x = ornstein_uhlenbeck_sl(1:5)
y = reduce_to_paleoTS(x) # turn into paleoTS format
plot(y) # plot using the paleoTS package

# see also
#vignette("paleoTS_functionality")
#for details and advanced usage


}
\seealso{
\itemize{
\item \code{\link[=ornstein_uhlenbeck]{ornstein_uhlenbeck()}} to model mean trait values,
\item \code{\link[=reduce_to_paleoTS]{reduce_to_paleoTS()}} to transform outputs into \code{paleoTS} format
\item \code{\link[=stasis_sl]{stasis_sl()}}, \code{\link[=strict_stasis_sl]{strict_stasis_sl()}} and \code{\link[=random_walk_sl]{random_walk_sl()}} to simulate other modes of evolution
}
}
