% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_dr.R
\name{param_dr}
\alias{param_dr}
\title{Parameter Estimation: Double-robust estimator}
\usage{
param_dr(Y, A, X, mu_hat, Subgrps, alpha_ovrl, alpha_s, ...)
}
\arguments{
\item{Y}{The outcome variable. Must be numeric (binary, continuous)}

\item{A}{Treatment variable. (a=1,...A)}

\item{X}{Covariate space.}

\item{mu_hat}{Patient-level estimates (See PLE_models)}

\item{Subgrps}{Identified subgroups (can be the overall population)}

\item{alpha_ovrl}{Two-sided alpha level for overall population}

\item{alpha_s}{Two-sided alpha level at subgroup}

\item{...}{Any additional parameters, not currently passed through.}
}
\value{
Data-set with parameter estimates and corresponding variability metrics, 
for overall and subgroups. Subgrps=0 corresponds to the overall population by 
default.
 \itemize{
  \item param.dat - Parameter estimates and variability metrics (est, SE,
  LCL/UCL = lower/upper confidence limits, pval = p-value).
  }
}
\description{
For each identified subgroup and in the overall population, use the double robust
estimator (Funk et al 2011). For continuous and binary outcomes, this outputs 
estimates for E(Y|A=1), E(Y|A=0), and E(Y|A=1)-E(Y|A=0).
}
\examples{
library(StratifiedMedicine)

## Continuous ##
dat_ctns = generate_subgrp_data(family="gaussian")
Y = dat_ctns$Y
X = dat_ctns$X
A = dat_ctns$A

## Estimate PLEs (ranger) ##
res_ranger = ple_train(Y, A, X, Xtest=X, ple="ple_ranger")

## Identify Subgroups: MOB (lmtree) ##
res_lmtree = submod_train(Y, A, X, Xtest=X, submod="submod_lmtree")

## Parameter-estimation ##
params = param_dr(Y, A, X, mu_hat = res_ranger$mu_train,
                  Subgrps = res_lmtree$Subgrps.train, alpha_ovrl=0.05,
                  alpha_s=0.05)
params

}
