% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.PRISM}
\alias{plot.PRISM}
\title{plot.PRISM}
\usage{
\method{plot}{PRISM}(x, type = "submod", estimand = NULL,
  grid.data = NULL, grid.thres = ">0", est.resamp = TRUE, ...)
}
\arguments{
\item{x}{PRISM object}

\item{type}{Type of plot (default="submod", tree plot + parameter estimates). Other 
optins include  "forest" ( forest plot for overall and subgroups),"PLE:waterfall" 
(waterfall plot of PLEs), "PLE:density" (density plot of PLEs), "resample" (resampling 
distribution of parameter estimates for overall and subgroups), and "heatmap" 
(heatmap of ple estimates/probabilities). For "submod" and "forest", CIs are based on 
the observed data unless bootstrap resampling. If calibrate=TRUE (the default), then
calibrated CIs are shown, otherse CIs based on the percentile method are shown.}

\item{estimand}{For "resample" plot only, must be specify which estimand to visualize.
Default=NULL.}

\item{grid.data}{Input grid of values for 2-3 covariates (if 3, last variable cannot
be continuous). This is required for type="heatmap". Default=NULL.}

\item{grid.thres}{Threshold for PLE, ex: I(PLE>thres). Used to estimate P(PLE>thres) for
type="heatmap". Default is ">0". Direction can be reversed and can include equality
sign (ex: "<=").}

\item{est.resamp}{Should plot present resampling based estimates? Default=TRUE if 
bootstrap or CV  based resampling is used. Only applicable for type="submod". 
If bootstrap calibration is used, calibrated CIs are presented. If no calibration,
then percentile Cis are presented with the smoothed bootstrap point-estimates.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
Plot (ggplot2) object
}
\description{
Plots PRISM results, either forest plot (estimate with CIs) or resampling distribution.
}
\seealso{
\code{\link{PRISM}}
}
