% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weld.R
\name{weld}
\alias{weld}
\title{Combines segments with "litholog()"-like data frame}
\usage{
weld(log, dt, xy, begin, end, erase = "none", order = "current")
}
\arguments{
\item{log}{a "litholog()"-like data frame on which the new segment
needs to be welded.}

\item{dt}{the dt value for each point of the added segment.}

\item{xy}{the xy value for each point of the added segment.}

\item{begin}{the row of log after which the segment will be added.}

\item{end}{the row of log before which the segment will be added
(end should be superior to begin).}

\item{erase}{erase the begin point ('begin'), end point ('end'), both
('both') or only the points in between ('none').}

\item{order}{the order of the added points : can be the current order
('current'), the current order inversed ('inverse'), or ordered by xy ('xy'
or '-xy') or dt ('dt' or '-dt').}
}
\value{
a "litholog()"-like data frame with the bed
that comprises the begin
and end row having the segment welded to it.
}
\description{
Adds segments to the polygon forming the bed of a log in a
"litholog()"-like data frame.
}
\examples{
l <- c(1)
r <- c(2)
h <- c(4)
i <- c("B1")
log <- litholog(l, r, h, i)

seg <- sinpoint(4, 1, 0.25, pos = 2, phase = 0.5)
welded <- weld(log, seg$y, seg$x, 3, 4, order = "inverse", erase = "both")

plot(c(-1,5),c(0,3),type = "n")

multigons(log$i,log$xy,log$dt)
points(seg$x,seg$y)

multigons(welded$i, welded$xy, welded$dt, lty = 2, lwd = 3, border = "red")

}
\seealso{
\code{\link{litholog}} and \code{\link{weldlog}}
}
