% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointsvg.R
\name{pointsvg}
\alias{pointsvg}
\alias{is.pointsvg}
\title{Converts line, rect, polygon and polyline class SVG objects into
data frames}
\usage{
pointsvg(
  file,
  standard = TRUE,
  keep.ratio = FALSE,
  round = TRUE,
  xdigits = 4,
  ydigits = 4,
  xinverse = FALSE,
  yinverse = TRUE,
  warn = T
)

is.pointsvg(object)
}
\arguments{
\item{file}{a .svg file}

\item{standard}{whether to standardise (centre to (0,0), rescale so
that extreme points are at -1 and 1) (T or F)}

\item{keep.ratio}{if the object is to be  standardised, whether to
keep the x/y ratio (T or F)}

\item{round}{whether to round the coordinates (T or F)}

\item{xdigits}{the number of digits after the decimal to round to for
x values}

\item{ydigits}{the number of digits after the decimal to round to for
y values}

\item{xinverse}{whether to inverse the plotting for x values (T or F)}

\item{yinverse}{whether to inverse the plotting for y values (T or F)}

\item{warn}{whether you want to be annoyed}

\item{object}{for is.pointsvg, the R object to be checked if it can be
considered similarly to a svg outputted by pointsvg}
}
\value{
A data.frame with x and y coordinates, ids for each object, and a
type, either line (L) or polygon (P)
}
\description{
Converts 'line', 'rect', 'polygon' and 'polyline' class SVG
objects into data frames. \strong{ONLY THESE CLASSES OF OBJECTS CAN BE
IMPORTED.} If you have bezier or spline curves, they will be stored as 'path'
class objects that cannot be imported here. The same goes for 'rect' objects
that are transformed (rotation, etc...).
}
\details{
This function is quite empirical. There is no guarantee it is bug
free. If you have .svg files that should work but do not, you can email me:
\email{wouterseb@gmail.com}
}
\examples{
# To show you how to import, we first have to have a svg file to import. The
#following lines of code will create a svg in a temporary files:

svg.file.directory <- tempfile(fileext = ".svg") # Creates temporary file
writeLines(example.ammonite.svg, svg.file.directory) # Writes svg in the file

print(paste("An example .svg file was created at ", svg.file.directory,
            sep = ""))

# The pointsvg function allows to import simple svg drawings into R

ammonite.drawing <- pointsvg(file = svg.file.directory) # Provide file

is.pointsvg(ammonite.drawing)

plot(c(-2,2), c(-2,2), type = "n")

placesvg(ammonite.drawing)

# If you want to import your own .svg file uncomment the following line:

# pointsvg(file.choose())

}
\seealso{
Plot the drawing: \code{\link{placesvg}},

Plot the drawing and change the coordinates :\code{\link{centresvg}} and
\code{\link{framesvg}}

Change the drawing: \code{\link{changesvg}} and \code{\link{clipsvg}}
}
