% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weldjoint.R
\name{weldjoint}
\alias{weldjoint}
\title{Changes boundaries segments in basic lithologs}
\usage{
weldjoint(
  log,
  dt,
  collection,
  sym,
  yinv = F,
  xinv = F,
  yleft = 0,
  yright = NA,
  ymin = NA,
  ymax = NA,
  xmin = 0,
  xmax = max(log$xy),
  add.dt = 0,
  tolerance = 8
)
}
\arguments{
\item{log}{a "litholog()"-like data frame on which the new segments
need to be welded.}

\item{dt}{the position of the n boundaries to change.}

\item{collection}{a collection object (e.g. oufti)}

\item{sym}{the name of the symbols in the collection. This should be a symbol
that can be considered as a bedding joint; see \code{\link{is.joint}}.}

\item{yinv, xinv}{whether to inverse the plotting for x and y values (T or F)}

\item{yleft, yright}{the depth/height/time value for the extreme point at the
right or left of the joint (yleft overruns yright, which overruns ymin and
ymax)}

\item{ymin, ymax}{the extreme values for the y axis (in case of conflict with
yleft and/or yright, defaults to the smallest exaggeration)}

\item{xmin, xmax}{the extreme values for the x axis}

\item{add.dt}{whether to automatically add the dt value to the dt of
the segments (with the add.dt value when it is not zero)}

\item{tolerance}{the order of tolerance for errors, i.e. the number of
decimals considered as being meaningful for matching dt to log}
}
\value{
a "litholog()"-like data frame, with new bed boundaries
}
\description{
Adds personalised segments to bed boundaries of lithologs from
"litholog()"-like data frames
}
\examples{
# Generate litholog ----

l <- c(0,1,2,3,4)
r <- c(1,2,3,4,5)
h   <- c(4,3,4,3,4)
i <- c("B1","B2","B3","B4","B5")
log  <- litholog(l, r, h, i)

# Modify the boundaries of the litholog ----

nlog <- weldjoint(log, c(1,2,3,4), oufti99,
                  sym = c("1sin", "stylolith", "3sin", "liquefaction"),
                  ymax  = c(NA, NA, NA, 0.2),
                  xmin  = c(0,0,0,1),
                  xmax  = c(4,4,4,1.5))

# Visualise

par(mfrow = c(1,2))

plot.new()
plot.window(xlim = c(0,5), ylim = c(0,5))

axis(1)
axis(2)

multigons(log$i, log$xy, log$dt)

plot.new()
plot.window(xlim = c(0,5), ylim = c(0,5))

axis(1)
axis(2)

multigons(nlog$i, nlog$xy, nlog$dt)

}
