% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetPriorMeans.R
\name{GetPriorMeans}
\alias{GetPriorMeans}
\title{Calibrates prior means for Dose Finding Trial}
\usage{
GetPriorMeans(Clinician, Dose)
}
\arguments{
\item{Clinician}{#Groups X #Doses matrix containing the elicited prior toxicity probabilities at the reference time for each dose and subgroup.}

\item{Dose}{Vector containing standardized doses.}
}
\value{
Returns a list containing in order: the prior mean of the common baseline intercept, the prior mean of the common slope, the vector of subgroup specific intercepts and the vector of subgroup specific slopes.
}
\description{
Uses the clinician elicited prior reference probabilities for each subgroup and dose to obtain prior means for the Bayesian logistic regression model used in the SubTite trial design.
}
\examples{
##Specify elicited reference toxicity probabilities
Clinician = matrix(c(.2,.3,.4,.5,.6,.1,.2,.3,.4,.5,.05,.1,.15,.2,.3),byrow=TRUE,nrow=3)
Dose=rnorm(5)
GetPriorMeans(Clinician,Dose)
}
\references{
[1] Chapple and Thall (2017), Subgroup-specific Dose Finding in Phase I Clinical Trials Based on Time to Toxicity.
}
