% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GroupMCMCLN.R
\name{GroupMCMCLN}
\alias{GroupMCMCLN}
\title{Performs MCMC for model used in the SubTite design}
\usage{
GroupMCMCLN(Y, I, Doses, Groups, meanmu, meanslope, MeanInts, MeanSlopes, B, T1)
}
\arguments{
\item{Y}{Vector containing observed event or censoring times.}

\item{I}{Vector containing event indicators (1 if patient experiences an event for a patient).}

\item{Doses}{Vector containing Doses of patients in trial.}

\item{Groups}{Vector containing group assignment of patients, 1 is baseline group.}

\item{meanmu}{Prior mean of common intercept parameter.}

\item{meanslope}{Prior mean of common slope parameter.}

\item{MeanInts}{Vector of prior means for the group specific intercept parameters.}

\item{MeanSlopes}{Vector of prior means for the group specific slope parameters.}

\item{B}{Number of iterations to perform in the MCMC.}

\item{T1}{Reference time for Toxicity}
}
\value{
Returns a list containing the posterior samples for the common intercept, the common slope, the vector of group specific intercepts, the vector of group specific slopes and sigma^2.
}
\description{
Returns a list containing the posterior samples for the logistic model parameters.
}
\examples{
##Specify reference toxicity time and target
T1=6
B=2000
##Randomly generate data for use.
n=60
Y=runif(n,0,100)
I=rbinom(n,1,.5)
Y[I==0]=T1
Groups = sample(1:3,n,replace=TRUE)
Doses = sample(1:5,n,replace=TRUE)
##Doses Tried so far in trial
##Hypermeans for linear terms
meanmu=2.21
meanslope=-.57
MeanInts = c(.46, .55)
MeanSlopes = c(.04,.10)
GroupMCMCLN( Y,I,Doses,Groups,meanmu,meanslope,MeanInts,MeanSlopes, B,T1)
}
\references{
[1] Chapple and Thall (2017), Subgroup-specific Dose Finding in Phase I Clinical Trials Based on Time to Toxicity.
}
