% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prim.R
\name{prim.train.pred.once}
\alias{prim.train.pred.once}
\title{Apply PRIM one time on the training data for a fixed value of alpha in predictive case}
\usage{
prim.train.pred.once(data, yvar, censorvar, trtvar, xvars, type, des.res,
  alpha = 0.1, min.size.inside = 20, pidx.train.test)
}
\arguments{
\item{data}{input data frame}

\item{yvar}{name for response variable}

\item{censorvar}{name for censoring (1: event; 0: censor), default = NULL}

\item{trtvar}{0-1 coded vector for treatment variable}

\item{xvars}{vector of variable names for predictors (covariates)}

\item{type}{type of response variable: "c" continuous (default); "s" survival; "b" binary}

\item{des.res}{the desired response. "larger": prefer larger response (default) "smaller": prefer smaller response}

\item{alpha}{a parameter controlling the number of patients in consideration}

\item{min.size.inside}{desired number of subjects in signature positive group size for a given cutoff.}

\item{pidx.train.test}{training and test data index as obtained from create.training.dataset.index}
}
\value{
a list containing signature rules and test result based on the signatures.
}
\description{
this function applies the prim procedure (peeling, pasting, and dropping operations) on training data one time.
}
