% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDScoreHeatmap.R
\name{plotDScoreHeatmap}
\alias{plotDScoreHeatmap}
\title{Plot a heat map of the normalized drug-disease reverse association scores for cancer samples}
\usage{
plotDScoreHeatmap(
  data,
  SDS.threshold = 0,
  FDR.threshold = 0.01,
  subtype.label = "all",
  show.rownames = TRUE,
  show.colnames = TRUE,
  fontsize = 10,
  fontsize.row = 10,
  fontsize.col = 10,
  scale = "none"
)
}
\arguments{
\item{data}{A list of result data generated by function `OCSSD()`.}

\item{SDS.threshold}{A numeric. Indicate the range of SDS scores for the drug shown in
the heat map. When SDS.threshold = 0 (default), SDS will not be screened. If
SDS.threshold is a number greater than zero, the heat map only shows drugs with SDS >= SDS.threshold. When SDS.threshold is a number less than zero,
the heat map only shows drugs with SDS <= SDS.threshold..}

\item{FDR.threshold}{Set the threshold of FDR (default: 0.01), and drugs with FDR less than the threshold are used for heat map.}

\item{subtype.label}{Character string indicates which sample of the cancer subtype was used to plot the heat map.
If subtype.label = "all" (default), all cancer samples will be shown in the heat map.}

\item{show.rownames}{Boolean specifying if row names are be shown.}

\item{show.colnames}{Boolean specifying if column names are be shown.}

\item{fontsize}{Base fontsize for the plot (default: 10).}

\item{fontsize.row}{Fontsize for rownames (default: 10).}

\item{fontsize.col}{Fontsize for colnames (default: 10).}

\item{scale}{Character indicating if the values should be centered and scaled in either the row direction or the column direction, or none. Corresponding values are "row", "column" and "none".}
}
\value{
A heat map.
}
\description{
The `plotDScoreHeatmap()` screen for significant cancer related
or cancer subtype specific drugs based on user set FDR threshold and sutype-specific drug score (SDS) range. And
shown in the form of a heat map.
}
\details{
plotDScoreHeatmap
}
\examples{
require(pheatmap)
## Get the result data of OCSSD().
## The data is based on the simulated breast cancer subtype data.
Subtype_drugs<-get("Subtype_drugs")
## Heat map of all subtype-specific drugs.
\donttest{plotDScoreHeatmap(data=Subtype_drugs,show.rownames = TRUE,show.colnames = FALSE)}
## Plot only Basal subtype-specific drugs.
plotDScoreHeatmap(data=Subtype_drugs,subtype.label="Basal",show.colnames = FALSE)
}
\author{
Xudong Han,
Junwei Han,
Chonghui Liu
}
