% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tpk-read_data.R
\name{read_df_raw}
\alias{read_df_raw}
\title{Read in Raw Data from Dataframe}
\usage{
read_df_raw(df, tracer_accuracy, t_period)
}
\arguments{
\item{df}{dataframe; the IV curve data to be filtered}

\item{tracer_accuracy}{The accuracy of the IV tracer used. See the device's manual
to find the exact value at which Isc readings are no longer accurate.}

\item{t_period}{Data period for the Psuedo-IV curves. Addded as a column to the dataframe
based on the timestamp. Use units of days, i.e. daily periods should have t_period 1,
weekly periods should have t_period 7, etc.}
}
\value{
df_raw, a dataframe containing the raw IV curve data
}
\description{
Given an imported datafram of Hbase-Formatted IV curve data,
this function reads in the data, filters missing temperature data,
and checks for a nonzero maximum power point, in case of power loss.
It resets the timestamps based on the minimum timestamp, and filters
Isc values for the tracer's accuracy.
Finally, a n_period counter is added to the dataframe.
}
\examples{
df_test <- read_df_raw(df_wbw, 1, 7) # Weekly periods
df_test <- read_df_raw(df_wbw, 1, 1) # Daily periods

}
