% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sra.R
\name{random_list_sra}
\alias{random_list_sra}
\title{Simulate sequential rank agreement for randomized unrelated lists}
\usage{
random_list_sra(object, B = 1, n = 1, na.strings = NULL,
  nitems = NULL, type = c("sd", "mad"), epsilon = 0)
}
\arguments{
\item{object}{A matrix of numbers or list of vectors representing ranked lists.}

\item{B}{An integer giving the number of randomizations to sample
over in the case of censored observations}

\item{n}{Integer: the number of permutation runs. For each permutation run we permute each of the lists in object
and compute corresponding the sequential rank agreement curves}

\item{na.strings}{A vector of character values that represent
censored observations}

\item{nitems}{The total number of items in the original lists if we only have partial lists available. Will be derived from the unique elements of the object if set to \code{NULL} (the default)}

\item{type}{The type of measure to use. Either sd (standard
deviation - the default) or mad (median absolute deviance)}

\item{epsilon}{A non-negative numeric vector that contains the minimum limit in proportion of lists that must show the item. Defaults to 0. If a single number is provided then the value will be recycles to the number of items. Should usually be low.}
}
\value{
A matrix with n columns and the same number of rows as for the input object. Each column contains one
simulated sequential rank agreement curve from one permutation run.
}
\description{
Simulate sequential rank agreement from completely uninformative lists (ie., raw permutations of items) and compute the corresponding sequential rank agreement curves.
The following attributes are copied from the input object: number of lists, number of items and amount of censoring.
}
\examples{
# setting with 3 lists
mlist <- matrix(cbind(1:8,c(1,2,3,5,6,7,4,8),c(1,5,3,4,2,8,7,6)),ncol=3)
# compute sequential rank agreement of lists
sra(mlist)
# compute sequential rank agreement of 5 random permutations
random_list_sra(mlist, n=5)

}
\author{
Claus Ekstrøm <ekstrom@sund.ku.dk>
}
